/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.block;

import net.bunten.enderscape.block.properties.MagniaType;
import net.bunten.enderscape.util.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class MagniaBlock
extends Block {
    private final MagniaType magniaType;

    public MagniaBlock(MagniaType magniaType, BlockBehaviour.Properties properties) {
        super(properties);
        this.magniaType = magniaType;
    }

    public static MagniaType getMagniaType(BlockState state) {
        MagniaType magniaType;
        Block block = state.getBlock();
        if (block instanceof MagniaBlock) {
            MagniaBlock sprout = (MagniaBlock)block;
            magniaType = sprout.magniaType;
        } else {
            magniaType = null;
        }
        return magniaType;
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        super.animateTick(state, level, pos, random);
        if (random.nextInt(800) == 0 && !BlockUtil.isBlockObstructed(level, pos)) {
            level.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, this.magniaType.getHumSound(), SoundSource.AMBIENT, 1.0f, 1.0f, false);
        }
    }
}

