/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.block;

import net.bunten.enderscape.block.DirectionalPlantBlock;
import net.bunten.enderscape.block.MagniaSproutBlockEntity;
import net.bunten.enderscape.block.properties.DirectionProperties;
import net.bunten.enderscape.block.properties.MagniaType;
import net.bunten.enderscape.block.properties.StateProperties;
import net.bunten.enderscape.registry.EnderscapeBlockEntities;
import net.bunten.enderscape.registry.tag.EnderscapeBlockTags;
import net.bunten.enderscape.registry.tag.EnderscapeItemTags;
import net.bunten.enderscape.util.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.SignalGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public abstract class MagniaSproutBlock
extends DirectionalPlantBlock
implements SimpleWaterloggedBlock,
EntityBlock {
    public static final BooleanProperty POWERED = StateProperties.POWERED;
    public static final BooleanProperty OVERHEATED = StateProperties.OVERHEATED;
    public static final BooleanProperty WATERLOGGED = StateProperties.WATERLOGGED;
    public final MagniaType magniaType;

    public MagniaSproutBlock(MagniaType magniaType, BlockBehaviour.Properties settings) {
        super(DirectionProperties.create().all(), settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)OVERHEATED, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.magniaType = magniaType;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new MagniaSproutBlockEntity(pos, state);
    }

    @Nullable
    protected static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> type1, BlockEntityType<E> type2, BlockEntityTicker<? super E> ticker) {
        return type2 == type1 ? ticker : null;
    }

    public static MagniaType getMagniaType(BlockState state) {
        MagniaType magniaType;
        Block block = state.getBlock();
        if (block instanceof MagniaSproutBlock) {
            MagniaSproutBlock sprout = (MagniaSproutBlock)block;
            magniaType = sprout.magniaType;
        } else {
            magniaType = null;
        }
        return magniaType;
    }

    public static boolean isPowered(BlockState state) {
        return state.getBlock() instanceof MagniaSproutBlock && (Boolean)state.getValue((Property)POWERED) != false;
    }

    public static boolean isOverheated(BlockState state) {
        return state.getBlock() instanceof MagniaSproutBlock && (Boolean)state.getValue((Property)OVERHEATED) != false;
    }

    public static boolean shouldOverheat(Level world, BlockPos origin) {
        for (Direction dir : Direction.values()) {
            BlockPos pos = origin.relative(dir);
            if (!world.getBlockState(pos).is(EnderscapeBlockTags.OVERHEATS_MAGNIA_SPROUTS)) continue;
            return true;
        }
        return false;
    }

    public static boolean canPullEntities(BlockState state) {
        return MagniaSproutBlock.isPowered(state) && !MagniaSproutBlock.isOverheated(state);
    }

    public static boolean isRepulsive(BlockState state) {
        return MagniaSproutBlock.getMagniaType(state) == MagniaType.REPULSIVE;
    }

    private boolean trySetPowered(BlockState state, Level level, BlockPos pos) {
        if (MagniaSproutBlock.isOverheated(state) || MagniaSproutBlock.shouldOverheat(level, pos) || !this.getNeighborSignal((SignalGetter)level, pos, (Direction)state.getValue((Property)FACING))) {
            return false;
        }
        return this.setPowered(state, level, pos, true);
    }

    private boolean setPowered(BlockState state, Level level, BlockPos pos, boolean powered) {
        Vec3 vec = Vec3.atCenterOf((Vec3i)pos);
        level.setBlock(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(powered)), 3);
        level.playSound(null, vec.x, vec.y, vec.z, powered ? this.magniaType.getPowerOnSound() : this.magniaType.getPowerOffSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
        level.gameEvent(null, (Holder)(powered ? GameEvent.BLOCK_ACTIVATE : GameEvent.BLOCK_DEACTIVATE), pos);
        return true;
    }

    private void setOverheated(BlockState state, Level level, BlockPos pos, boolean value) {
        if (value) {
            Vec3 vec = Vec3.atCenterOf((Vec3i)pos);
            BlockState updatedState = state;
            if (MagniaSproutBlock.isPowered(state)) {
                updatedState = (BlockState)updatedState.cycle((Property)POWERED);
                level.playSound(null, vec.x, vec.y, vec.z, this.magniaType.getOverheatSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            level.setBlock(pos, (BlockState)updatedState.setValue((Property)OVERHEATED, (Comparable)Boolean.valueOf(value)), 3);
            level.gameEvent(null, (Holder)GameEvent.BLOCK_CHANGE, pos);
        } else {
            level.setBlock(pos, (BlockState)state.setValue((Property)OVERHEATED, (Comparable)Boolean.valueOf(value)), 3);
            level.gameEvent(null, (Holder)GameEvent.BLOCK_CHANGE, pos);
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return !level.isClientSide() ? MagniaSproutBlock.createTickerHelper(type, EnderscapeBlockEntities.MAGNIA_SPROUT.get(), MagniaSproutBlockEntity::tick) : null;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, POWERED, OVERHEATED, WATERLOGGED});
    }

    @Override
    public boolean canPlantOn(BlockState state, BlockState floor, BlockGetter level, BlockPos pos, Direction facing) {
        return floor.isFaceSturdy(level, pos, facing) && floor.isSolidRender(level, pos.relative(facing.getOpposite()));
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return BlockUtil.createRotatedShape(3.0, 0.0, 3.0, 13.0, 13.0, 13.0, (Direction)state.getValue((Property)FACING));
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        if (state == null) {
            return null;
        }
        BlockPos pos = context.getClickedPos();
        Level level = context.getLevel();
        FluidState fluid = level.getFluidState(pos);
        boolean shouldOverheat = MagniaSproutBlock.shouldOverheat(level, pos);
        return (BlockState)((BlockState)((BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(this.getNeighborSignal((SignalGetter)level, pos, (Direction)state.getValue((Property)FACING)) && !shouldOverheat))).setValue((Property)OVERHEATED, (Comparable)Boolean.valueOf(shouldOverheat))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluid.getType() == Fluids.WATER));
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState state2, LevelAccessor world, BlockPos pos, BlockPos pos2) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            world.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        return super.updateShape(state, direction, state2, world, pos, pos2);
    }

    public FluidState getFluidState(BlockState state) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            return Fluids.WATER.getSource(false);
        }
        return super.getFluidState(state);
    }

    private boolean getNeighborSignal(SignalGetter getter, BlockPos pos, Direction facing) {
        for (Direction direction : Direction.values()) {
            if (direction == facing || !getter.hasSignal(pos.relative(direction), direction)) continue;
            return true;
        }
        if (getter.hasSignal(pos, Direction.DOWN)) {
            return true;
        }
        BlockPos abovePos = pos.above();
        for (Direction direction : Direction.values()) {
            if (direction == Direction.DOWN || !getter.hasSignal(abovePos.relative(direction), direction)) continue;
            return true;
        }
        return false;
    }

    private void updateState(BlockState state, Level level, BlockPos pos, boolean schedule) {
        if (level.isClientSide()) {
            return;
        }
        boolean hasSignal = this.getNeighborSignal((SignalGetter)level, pos, (Direction)state.getValue((Property)FACING));
        boolean shouldOverheat = MagniaSproutBlock.shouldOverheat(level, pos);
        boolean overheated = MagniaSproutBlock.isOverheated(state);
        boolean powered = MagniaSproutBlock.isPowered(state);
        if (overheated != shouldOverheat) {
            this.setOverheated(state, level, pos, shouldOverheat);
        }
        if (powered != hasSignal) {
            if (hasSignal) {
                this.trySetPowered(state, level, pos);
            } else if (schedule) {
                level.scheduleTick(pos, (Block)this, 5);
            } else {
                this.setPowered(state, level, pos, false);
            }
        }
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos pos2, boolean bl) {
        this.updateState(state, level, pos, true);
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        this.updateState(state, (Level)level, pos, false);
    }

    protected void attack(BlockState state, Level level, BlockPos pos, Player player) {
        if (!MagniaSproutBlock.isPowered(state) && player.getItemInHand(InteractionHand.MAIN_HAND).is(EnderscapeItemTags.POWERS_MAGNIA_WHEN_MINED_WITH) && this.trySetPowered(state, level, pos)) {
            level.scheduleTick(pos, (Block)this, 30);
        }
        super.attack(state, level, pos, player);
    }

    public void onProjectileHit(Level level, BlockState state, BlockHitResult hit, Projectile projectile) {
        BlockPos pos = hit.getBlockPos();
        if (!MagniaSproutBlock.isPowered(state) && !MagniaSproutBlock.isOverheated(state) && this.trySetPowered(state, level, pos)) {
            level.scheduleTick(pos, (Block)this, 20);
        }
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (MagniaSproutBlock.canPullEntities(state)) {
            Vec3 midair;
            Vec3 center = Vec3.atCenterOf((Vec3i)pos);
            Vec3 origin = midair = Vec3.atCenterOf((Vec3i)pos.relative(MagniaSproutBlock.getFacing(state), 6));
            double xs = (center.x() - midair.x()) * (double)0.2f;
            double ys = (center.y() - midair.y()) * (double)0.2f;
            double zs = (center.z() - midair.z()) * (double)0.2f;
            if (MagniaSproutBlock.isRepulsive(state)) {
                xs = -xs;
                ys = -ys;
                zs = -zs;
                origin = center;
            }
            level.addParticle(this.magniaType.getParticle(), origin.x() + random.nextGaussian() / 4.0, origin.y() + random.nextGaussian() / 3.0, origin.z() + random.nextGaussian() / 4.0, xs, ys, zs);
        }
    }
}

