/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.block;

import java.util.HashMap;
import net.bunten.enderscape.block.MagniaSproutBlock;
import net.bunten.enderscape.block.properties.MagniaType;
import net.bunten.enderscape.entity.magnia.MagniaMoveable;
import net.bunten.enderscape.entity.magnia.MagniaMovingData;
import net.bunten.enderscape.entity.magnia.MagniaProperties;
import net.bunten.enderscape.registry.EnderscapeBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class MagniaSproutBlockEntity
extends BlockEntity {
    private static final HashMap<Direction, Vec3i> DIRECTION_TO_VEC3I = new HashMap();

    public MagniaSproutBlockEntity(BlockPos pos, BlockState state) {
        super(EnderscapeBlockEntities.MAGNIA_SPROUT.get(), pos, state);
    }

    public static AABB getRange(Level level, BlockState state, BlockPos originPos) {
        Direction direction = MagniaSproutBlock.getFacing(state);
        MagniaType type = MagniaSproutBlock.getMagniaType(state);
        if (type != null) {
            BlockPos current = originPos;
            float maxRange = 14.0f;
            int i = 1;
            while ((float)i <= maxRange && !level.getBlockState(current = originPos.relative(direction, i)).is(type.getBlockedByTag())) {
                ++i;
            }
            Vec3 start = Vec3.atCenterOf((Vec3i)originPos.relative(direction)).add(Vec3.atLowerCornerOf((Vec3i)DIRECTION_TO_VEC3I.get(direction)).scale(-1.0));
            Vec3 end = Vec3.atCenterOf((Vec3i)current).add(Vec3.atLowerCornerOf((Vec3i)DIRECTION_TO_VEC3I.get(direction)).scale(-0.5));
            AABB range = new AABB(start, end);
            return switch (direction.getAxis()) {
                default -> throw new MatchException(null, null);
                case Direction.Axis.X -> range.inflate(0.0, 0.75, 0.75);
                case Direction.Axis.Y -> range.inflate(0.75, 0.0, 0.75);
                case Direction.Axis.Z -> range.inflate(0.75, 0.75, 0.0);
            };
        }
        return new AABB(originPos);
    }

    private static void move(Entity entity, Vec3 velocity) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            player.connection.send((Packet)new ClientboundSetEntityMotionPacket(entity));
        }
        if (MagniaMoveable.getMagniaProperties(entity).shouldAddVelocity().test(entity)) {
            entity.addDeltaMovement(velocity);
        } else {
            entity.setDeltaMovement(velocity);
        }
    }

    static void doMagniaMovement(Entity entity, MagniaSproutBlockEntity blockEntity) {
        MagniaProperties properties = MagniaMoveable.getMagniaProperties(entity);
        if (properties == null) {
            return;
        }
        properties.onMoved().apply(entity);
        Vec3 pos = entity.getBoundingBox().getCenter();
        BlockState state = blockEntity.getBlockState();
        Direction facing = (Direction)state.getValue((Property)MagniaSproutBlock.FACING);
        if (MagniaSproutBlock.isRepulsive(state)) {
            float factor = properties.repelStrength().apply(entity).floatValue();
            Vec3 velocity = new Vec3((double)facing.getStepX(), (double)facing.getStepY(), (double)facing.getStepZ()).normalize().multiply((double)factor, (double)factor, (double)factor);
            MagniaSproutBlockEntity.move(entity, velocity);
            entity.hasImpulse = true;
            if (!MagniaMovingData.wasMovedByMagnia(entity)) {
                entity.playSound(MagniaSproutBlock.getMagniaType(state).getMoveSound(), 1.0f, 1.0f);
            }
            MagniaMovingData.setMovedByMagnia(entity, true);
        } else {
            double distance;
            Vec3 moveTarget = Vec3.atCenterOf((Vec3i)blockEntity.getBlockPos()).add((double)((float)facing.getStepX() * 1.2f), (double)((float)facing.getStepY() * 1.2f), (double)((float)facing.getStepZ() * 1.2f));
            if (MagniaSproutBlockEntity.shouldOffset(blockEntity, facing)) {
                moveTarget = moveTarget.subtract(0.0, entity.getBoundingBox().getYsize() * (double)1.2f, 0.0);
            }
            if ((distance = pos.distanceTo(moveTarget)) > (double)0.1f) {
                Vec3 velocity = moveTarget.subtract(pos).normalize().scale((double)(properties.attractStrength().apply(entity).floatValue() * (float)Math.min(distance / 5.0, 1.0)));
                if (distance < 1.5) {
                    velocity = velocity.scale((double)((float)(0.75 + distance / 2.0 * 0.25)));
                }
                MagniaSproutBlockEntity.move(entity, velocity);
                entity.hasImpulse = true;
                if (!MagniaMovingData.wasMovedByMagnia(entity)) {
                    entity.playSound(MagniaSproutBlock.getMagniaType(state).getMoveSound(), 1.0f, 1.0f);
                }
                MagniaMovingData.setMovedByMagnia(entity, true);
            } else {
                MagniaSproutBlockEntity.move(entity, Vec3.ZERO);
                entity.hasImpulse = true;
                MagniaMovingData.setMovedByMagnia(entity, true);
            }
        }
    }

    private static boolean shouldOffset(MagniaSproutBlockEntity entity, Direction facing) {
        return facing != Direction.UP && !entity.getLevel().getBlockState(entity.getBlockPos().relative(facing).below()).isAir();
    }

    public static void tick(Level level, BlockPos pos, BlockState state, MagniaSproutBlockEntity entity) {
        if (!MagniaSproutBlock.canPullEntities(state)) {
            return;
        }
        level.getEntitiesOfClass(Entity.class, MagniaSproutBlockEntity.getRange(level, state, pos), MagniaMoveable::canMagniaAffect).forEach(moved -> MagniaSproutBlockEntity.doMagniaMovement(moved, entity));
    }

    static {
        DIRECTION_TO_VEC3I.put(Direction.DOWN, new Vec3i(0, -1, 0));
        DIRECTION_TO_VEC3I.put(Direction.UP, new Vec3i(0, 1, 0));
        DIRECTION_TO_VEC3I.put(Direction.NORTH, new Vec3i(0, 0, -1));
        DIRECTION_TO_VEC3I.put(Direction.SOUTH, new Vec3i(0, 0, 1));
        DIRECTION_TO_VEC3I.put(Direction.WEST, new Vec3i(-1, 0, 0));
        DIRECTION_TO_VEC3I.put(Direction.EAST, new Vec3i(1, 0, 0));
    }
}

