/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.block;

import com.mojang.serialization.MapCodec;
import java.util.Optional;
import net.bunten.enderscape.block.DirectionalPlantBlock;
import net.bunten.enderscape.block.properties.DirectionProperties;
import net.bunten.enderscape.block.properties.StateProperties;
import net.bunten.enderscape.registry.EnderscapeBlockSounds;
import net.bunten.enderscape.registry.EnderscapeBlocks;
import net.bunten.enderscape.registry.EnderscapeConfiguredFeatures;
import net.bunten.enderscape.registry.tag.EnderscapeBlockTags;
import net.bunten.enderscape.util.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MurublightChanterelleBlock
extends DirectionalPlantBlock
implements BonemealableBlock {
    public static final IntegerProperty STAGE = StateProperties.STAGE;
    public static final MapCodec<MurublightChanterelleBlock> CODEC = MurublightChanterelleBlock.simpleCodec(MurublightChanterelleBlock::new);
    private final ConfiguredFeatureFunction<BlockState> featureFunction = state -> DirectionalPlantBlock.getFacing(state) == Direction.UP ? EnderscapeConfiguredFeatures.UPWARD_LARGE_MURUBLIGHT_CHANTERELLE : EnderscapeConfiguredFeatures.DOWNWARD_LARGE_MURUBLIGHT_CHANTERELLE;

    public MurublightChanterelleBlock(BlockBehaviour.Properties properties) {
        super(DirectionProperties.create().vertical(), properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)STAGE, (Comparable)Integer.valueOf(0)));
    }

    public MapCodec<MurublightChanterelleBlock> codec() {
        return CODEC;
    }

    private Optional<? extends Holder<ConfiguredFeature<?, ?>>> getFeature(LevelReader level, BlockState state) {
        return level.registryAccess().lookupOrThrow(Registries.CONFIGURED_FEATURE).get(this.featureFunction.get(state));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, STAGE});
    }

    @Override
    public boolean canPlantOn(BlockState state, BlockState floor, BlockGetter level, BlockPos pos, Direction facing) {
        return floor.is(EnderscapeBlockTags.CORRUPT_BARRENS_VEGETATION_PLANTABLE_ON);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return BlockUtil.createRotatedShape(3.0, 0.0, 3.0, 13.0, 11.0, 13.0, MurublightChanterelleBlock.getFacing(state));
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockState relative = level.getBlockState(pos.relative(MurublightChanterelleBlock.getFacing(state).getOpposite()));
        if (relative.is(EnderscapeBlockTags.CORRUPTION_PURIFIES_ON) && random.nextInt(8) == 0) {
            MurublightChanterelleBlock.purify(level, pos);
        }
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        BlockState relative = level.getBlockState(pos.relative(MurublightChanterelleBlock.getFacing(state).getOpposite()));
        if (relative.getBlock() instanceof DirectionalBlock && MurublightChanterelleBlock.getFacing(relative) != MurublightChanterelleBlock.getFacing(state)) {
            return false;
        }
        return relative.is(EnderscapeBlockTags.MURUBLIGHT_CHANTERELLE_MATURES_ON) || relative.is(EnderscapeBlockTags.CORRUPTION_PURIFIES_ON);
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        BlockState relative = level.getBlockState(pos.relative(MurublightChanterelleBlock.getFacing(state).getOpposite()));
        return relative.is(EnderscapeBlockTags.CORRUPTION_PURIFIES_ON) || random.nextFloat() < 0.2f;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        BlockState relative = level.getBlockState(pos.relative(MurublightChanterelleBlock.getFacing(state).getOpposite()));
        if (relative.is(EnderscapeBlockTags.CORRUPTION_PURIFIES_ON)) {
            MurublightChanterelleBlock.purify(level, pos);
        } else if ((Integer)state.getValue((Property)STAGE) == 0) {
            level.setBlock(pos, (BlockState)state.cycle((Property)STAGE), 4);
        } else {
            this.getFeature((LevelReader)level, state).ifPresent(holder -> {
                if (((ConfiguredFeature)holder.value()).place((WorldGenLevel)level, level.getChunkSource().getGenerator(), random, pos) && level.getBlockState(pos).is((Block)this)) {
                    level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                }
            });
        }
    }

    private static void purify(ServerLevel level, BlockPos pos) {
        level.setBlockAndUpdate(pos, EnderscapeBlocks.CELESTIAL_CHANTERELLE.get().defaultBlockState());
        level.playSound(null, pos, EnderscapeBlockSounds.MURUBLIGHT_CHANTERELLE_PURIFY, SoundSource.BLOCKS, 1.0f, 1.0f);
        level.gameEvent(null, (Holder)GameEvent.BLOCK_CHANGE, pos);
    }

    @FunctionalInterface
    public static interface ConfiguredFeatureFunction<T> {
        public ResourceKey<ConfiguredFeature<?, ?>> get(T var1);
    }
}

