/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.block;

import com.mojang.serialization.MapCodec;
import net.bunten.enderscape.block.DirectionalPlantBlock;
import net.bunten.enderscape.block.properties.DirectionProperties;
import net.bunten.enderscape.block.properties.StateProperties;
import net.bunten.enderscape.registry.EnderscapeBlocks;
import net.bunten.enderscape.util.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MurublightShelfBlock
extends DirectionalPlantBlock
implements BonemealableBlock {
    public static final int MAX_AGE = 5;
    public static final IntegerProperty AGE = StateProperties.AGE_5;
    public static final MapCodec<MurublightShelfBlock> CODEC = MurublightShelfBlock.simpleCodec(MurublightShelfBlock::new);

    public MurublightShelfBlock(BlockBehaviour.Properties settings) {
        super(DirectionProperties.create().horizontal(), settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    public MapCodec<MurublightShelfBlock> codec() {
        return CODEC;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, AGE});
    }

    @Override
    public boolean canPlantOn(BlockState state, BlockState floor, BlockGetter level, BlockPos pos, Direction facing) {
        return floor.isFaceSturdy(level, pos, facing);
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        return BlockUtil.createRotatedShape(1.0, 0.0, 1.0, 15.0, 6.0, 15.0, (Direction)state.getValue((Property)FACING));
    }

    public boolean isValidBonemealTarget(LevelReader world, BlockPos pos, BlockState state) {
        return true;
    }

    public boolean isBonemealSuccess(Level world, RandomSource random, BlockPos pos, BlockState state) {
        return (double)random.nextFloat() < 0.7;
    }

    public void performBonemeal(ServerLevel world, RandomSource random, BlockPos origin, BlockState state) {
        if ((Integer)state.getValue((Property)AGE) < 5) {
            world.setBlock(origin, (BlockState)state.cycle((Property)AGE), 4);
        } else {
            int max = Mth.nextInt((RandomSource)random, (int)2, (int)4);
            int i = 0;
            for (BlockPos pos : BlockPos.randomInCube((RandomSource)random, (int)30, (BlockPos)origin, (int)Mth.nextInt((RandomSource)random, (int)3, (int)10))) {
                if (i >= max) break;
                if (world.getBlockState(pos).is((Block)this) || !MurublightShelfBlock.generate((LevelAccessor)world, origin)) continue;
                ++i;
            }
        }
    }

    private static BlockState stateForGeneration(Direction direction) {
        return (BlockState)((BlockState)EnderscapeBlocks.MURUBLIGHT_SHELF.get().defaultBlockState().setValue((Property)FACING, (Comparable)direction)).setValue((Property)AGE, (Comparable)Integer.valueOf(5));
    }

    public static boolean canGenerate(LevelAccessor world, BlockPos pos, Direction direction) {
        if (!world.getBlockState(pos).isAir() || direction.getAxis() == Direction.Axis.Y) {
            return false;
        }
        BlockPos relative = pos.relative(direction.getOpposite());
        return world.getBlockState(relative).isFaceSturdy((BlockGetter)world, relative, direction);
    }

    public static boolean generate(LevelAccessor world, BlockPos pos) {
        if (world.isEmptyBlock(pos) && world.isEmptyBlock(pos.above()) && world.isEmptyBlock(pos.below())) {
            for (Direction direction : Direction.values()) {
                BlockPos relative;
                if (direction.getAxis() == Direction.Axis.Y || !world.getBlockState(relative = pos.relative(direction.getOpposite())).isFaceSturdy((BlockGetter)world, relative, direction)) continue;
                world.setBlock(pos, MurublightShelfBlock.stateForGeneration(direction), 2);
                return true;
            }
        }
        return false;
    }
}

