/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.block;

import net.bunten.enderscape.registry.EnderscapeParticles;
import net.bunten.enderscape.registry.EnderscapeServerNetworking;
import net.bunten.enderscape.util.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class NebuliteOreBlock
extends DropExperienceBlock {
    public NebuliteOreBlock(BlockBehaviour.Properties settings) {
        super((IntProvider)UniformInt.of((int)6, (int)12), settings);
    }

    public static void makeParticles(int amount, int range, Level world, BlockPos pos, RandomSource random) {
        for (int i = 0; i < amount; ++i) {
            BlockPos pos2 = BlockUtil.random(pos, random, range, range, range);
            if (world.getBlockState(pos2).isCollisionShapeFullBlock((BlockGetter)world, pos2)) {
                return;
            }
            float xs = (float)(pos.getX() - pos2.getX()) * 0.04f;
            float ys = (float)(pos.getY() - pos2.getY()) * 0.04f;
            float zs = (float)(pos.getZ() - pos2.getZ()) * 0.04f;
            world.addParticle((ParticleOptions)EnderscapeParticles.NEBULITE_ORE.get(), (double)pos2.getX() + random.nextDouble(), (double)pos2.getY() + random.nextDouble(), (double)pos2.getZ() + random.nextDouble(), (double)xs, (double)ys, (double)zs);
        }
    }

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        EnderscapeServerNetworking.sendNebuliteOreSoundPayload(world, pos);
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        NebuliteOreBlock.makeParticles(Mth.nextInt((RandomSource)random, (int)1, (int)2), Mth.nextInt((RandomSource)random, (int)8, (int)12), world, pos, random);
    }
}

