/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.block;

import com.mojang.serialization.MapCodec;
import net.bunten.enderscape.registry.EnderscapeBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class RipeFlangerBerryBlock
extends Block {
    public static final MapCodec<RipeFlangerBerryBlock> CODEC = RipeFlangerBerryBlock.simpleCodec(RipeFlangerBerryBlock::new);

    public RipeFlangerBerryBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    public MapCodec<RipeFlangerBerryBlock> codec() {
        return CODEC;
    }

    protected int getFallDelay() {
        return 2;
    }

    protected boolean canFall(Level world, BlockPos pos) {
        boolean bl;
        boolean bl2 = bl = FallingBlock.isFree((BlockState)world.getBlockState(pos.below())) && world.getBlockState(pos.above()).getBlock() != EnderscapeBlocks.FLANGER_BERRY_VINE.get();
        if (pos.getY() < world.getMinBuildHeight()) {
            bl = false;
        }
        return bl;
    }

    public void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean notify) {
        world.scheduleTick(pos, (Block)this, this.getFallDelay());
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState state2, LevelAccessor world, BlockPos pos, BlockPos pos2) {
        world.scheduleTick(pos, (Block)this, this.getFallDelay());
        return super.updateShape(state, direction, state2, world, pos, pos2);
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (this.canFall((Level)world, pos)) {
            FallingBlockEntity.fall((Level)world, (BlockPos)pos, (BlockState)state);
        }
    }

    public void onProjectileHit(Level world, BlockState state, BlockHitResult hit, Projectile projectile) {
        if (projectile.getType().is(EntityTypeTags.IMPACT_PROJECTILES)) {
            world.destroyBlock(hit.getBlockPos(), true, (Entity)projectile);
        }
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level world, BlockPos pos) {
        return 6;
    }
}

