/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.block;

import com.mojang.serialization.MapCodec;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VeiledLeafPileBlock
extends Block {
    public static final MapCodec<VeiledLeafPileBlock> CODEC = VeiledLeafPileBlock.simpleCodec(VeiledLeafPileBlock::new);
    public static final IntegerProperty LAYERS = BlockStateProperties.LAYERS;

    public MapCodec<VeiledLeafPileBlock> codec() {
        return CODEC;
    }

    public VeiledLeafPileBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LAYERS, (Comparable)Integer.valueOf(1)));
    }

    protected void entityInside(BlockState state, Level levelZ, BlockPos pos, Entity entity) {
        int layers = VeiledLeafPileBlock.getLayers(state);
        if (layers >= 4) {
            float scale = 0.8f - (float)(layers - 4) * 0.21f;
            entity.makeStuckInBlock(state, new Vec3((double)scale, (double)scale, (double)scale));
        }
    }

    protected boolean isPathfindable(BlockState state, PathComputationType type) {
        if (Objects.requireNonNull(type) == PathComputationType.LAND) {
            return VeiledLeafPileBlock.getLayers(state) < 5;
        }
        return false;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        int layers = VeiledLeafPileBlock.getLayers(state);
        return Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)(layers * 2), (double)16.0);
    }

    protected VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return VeiledLeafPileBlock.getLayers(state) == 8 ? Shapes.block() : Shapes.empty();
    }

    @NotNull
    private static Integer getLayers(BlockState state) {
        return (Integer)state.getValue((Property)LAYERS);
    }

    protected int getLightBlock(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return 1;
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return VeiledLeafPileBlock.canSurvive(level, pos, state.getBlock());
    }

    public static boolean canSurvive(LevelReader level, BlockPos pos, Block block) {
        BlockState floor = level.getBlockState(pos.below());
        return Block.isFaceFull((VoxelShape)floor.getCollisionShape((BlockGetter)level, pos.below()), (Direction)Direction.UP) || floor.is(block) && VeiledLeafPileBlock.getLayers(floor) == 8;
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState state2, LevelAccessor world, BlockPos pos, BlockPos pos2) {
        return !state.canSurvive((LevelReader)world, pos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, direction, state2, world, pos, pos2);
    }

    protected boolean canBeReplaced(BlockState state, BlockPlaceContext context) {
        int i = VeiledLeafPileBlock.getLayers(state);
        if (!context.getItemInHand().is(this.asItem()) || i >= 8) {
            return i == 1;
        }
        return context.replacingClickedOnBlock() ? context.getClickedFace() == Direction.UP : true;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = context.getLevel().getBlockState(context.getClickedPos());
        if (state.is((Block)this)) {
            int i = VeiledLeafPileBlock.getLayers(state);
            return (BlockState)state.setValue((Property)LAYERS, (Comparable)Integer.valueOf(Math.min(8, i + 1)));
        }
        return super.getStateForPlacement(context);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{LAYERS});
    }
}

