/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.block;

import com.mojang.serialization.MapCodec;
import net.bunten.enderscape.block.AbstractOvergrowthBlock;
import net.bunten.enderscape.block.properties.DirectionProperties;
import net.bunten.enderscape.registry.EnderscapeBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class VeiledOvergrowthBlock
extends AbstractOvergrowthBlock {
    public static final MapCodec<VeiledOvergrowthBlock> CODEC = VeiledOvergrowthBlock.simpleCodec(VeiledOvergrowthBlock::new);

    public VeiledOvergrowthBlock(BlockBehaviour.Properties settings) {
        super(true, Blocks.END_STONE, null, null, false, DirectionProperties.create().up(), settings);
        this.horizontalBonemealRange = 4;
    }

    protected MapCodec<VeiledOvergrowthBlock> codec() {
        return CODEC;
    }

    @Override
    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos origin, BlockState state) {
        super.performBonemeal(level, random, origin, state);
        int i = 0;
        int max = Mth.nextInt((RandomSource)random, (int)3, (int)8);
        int range = Mth.nextInt((RandomSource)random, (int)4, (int)8);
        for (BlockPos pos : BlockPos.randomInCube((RandomSource)random, (int)30, (BlockPos)origin, (int)range)) {
            if (i >= max) break;
            BlockState plant = EnderscapeBlocks.VEILED_OVERGROWTH_BONEMEAL_PROVIDER.get().getState(random, pos);
            if (!level.isEmptyBlock(pos) || !level.getBlockState(pos.below()).is((Block)this)) continue;
            level.setBlock(pos, plant, 2);
            ++i;
        }
    }
}

