/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.block;

import com.mojang.serialization.MapCodec;
import net.bunten.enderscape.block.AbstractGrowthBlock;
import net.bunten.enderscape.block.properties.DirectionProperties;
import net.bunten.enderscape.registry.EnderscapeBlocks;
import net.bunten.enderscape.registry.EnderscapeParticles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class VeiledVinesBlock
extends AbstractGrowthBlock {
    public static final MapCodec<VeiledVinesBlock> CODEC = VeiledVinesBlock.simpleCodec(VeiledVinesBlock::new);

    public VeiledVinesBlock(BlockBehaviour.Properties settings) {
        super(DirectionProperties.create().up(), settings);
    }

    protected MapCodec<? extends BushBlock> codec() {
        return CODEC;
    }

    @Override
    public boolean canPlantOn(BlockState state, BlockState floor, BlockGetter level, BlockPos pos, Direction facing) {
        return floor.isFaceSturdy(level, pos, facing) || floor.is(EnderscapeBlocks.VEILED_LEAVES.get()) || this.hasGrowthSupport(state, floor);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        super.animateTick(state, level, pos, random);
        if (random.nextFloat() > 0.12f) {
            return;
        }
        level.addParticle((ParticleOptions)EnderscapeParticles.VEILED_LEAVES.get(), (double)pos.getX() + random.nextDouble(), (double)pos.getY() + random.nextDouble(), (double)pos.getZ() + random.nextDouble(), 0.25, random.nextGaussian() * 0.025, 0.25);
    }
}

