/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.block;

import net.bunten.enderscape.registry.EnderscapeBlockSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class VoidShaleBlock
extends Block {
    public static final int MAX_ITERATIONS = 60;
    public static final int MAX_STRESS = 4;
    public static final BooleanProperty COOLDOWN = BooleanProperty.create((String)"cooldown");
    public static final BooleanProperty NATURAL = BooleanProperty.create((String)"natural");
    public static final IntegerProperty ITERATION = IntegerProperty.create((String)"iteration", (int)0, (int)60);
    public static final IntegerProperty STRESS = IntegerProperty.create((String)"stress", (int)0, (int)4);

    public VoidShaleBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)COOLDOWN, (Comparable)Boolean.valueOf(false))).setValue((Property)NATURAL, (Comparable)Boolean.valueOf(true))).setValue((Property)ITERATION, (Comparable)Integer.valueOf(0))).setValue((Property)STRESS, (Comparable)Integer.valueOf(0)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{COOLDOWN, NATURAL, ITERATION, STRESS});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)NATURAL, (Comparable)Boolean.valueOf(false));
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (this.getStress(state) == 4) {
            boolean shouldDestroy = true;
            for (Direction dir : Direction.values()) {
                BlockPos relative = pos.relative(dir);
                BlockState other = level.getBlockState(relative);
                int iteration = this.getIteration(state) + 1 + random.nextInt(2);
                if (this.canAttach((Level)level, dir, other, relative)) {
                    shouldDestroy = false;
                    break;
                }
                if (!other.is((Block)this) || iteration >= 60) continue;
                level.setBlock(relative, (BlockState)((BlockState)other.setValue((Property)STRESS, (Comparable)Integer.valueOf(4))).setValue((Property)ITERATION, (Comparable)Integer.valueOf(iteration)), 2);
                level.scheduleTick(relative, (Block)this, 1);
            }
            if (shouldDestroy) {
                level.destroyBlock(pos, true);
            }
        } else if (this.onCooldown(state)) {
            level.setBlock(pos, (BlockState)state.cycle((Property)COOLDOWN), 2);
        }
    }

    public void stepOn(Level level, BlockPos pos, BlockState state, Entity entity) {
        LivingEntity living;
        if (entity instanceof LivingEntity && !(living = (LivingEntity)entity).hasEffect(MobEffects.SLOW_FALLING) && !this.onCooldown(state) && !this.isAttachedToBlock(level, pos)) {
            int stress = this.getStress(state);
            this.playShatterSound(level, pos, stress);
            level.setBlock(pos, (BlockState)((BlockState)((BlockState)state.setValue((Property)STRESS, (Comparable)Integer.valueOf(Math.min(4, stress + 1)))).setValue((Property)COOLDOWN, (Comparable)Boolean.valueOf(true))).setValue((Property)ITERATION, (Comparable)Integer.valueOf(0)), 2);
            level.scheduleTick(pos, (Block)this, living.isCrouching() ? 30 : 15);
        }
    }

    private void playShatterSound(Level level, BlockPos pos, int stress) {
        SoundEvent sound = EnderscapeBlockSounds.VOID_SHALE_SHATTER_SOUNDS.get(Math.min(3, stress));
        if (sound != SoundEvents.EMPTY) {
            level.playSound(null, pos, sound, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    private boolean canAttach(Level level, Direction dir, BlockState state, BlockPos relative) {
        return state.isFaceSturdy((BlockGetter)level, relative, dir) && !state.isAir() && !state.is((Block)this);
    }

    private boolean isAttachedToBlock(Level level, BlockPos pos) {
        for (Direction dir : Direction.values()) {
            BlockPos relative = pos.relative(dir);
            BlockState other = level.getBlockState(relative);
            if (!this.canAttach(level, dir, other, relative)) continue;
            return true;
        }
        return false;
    }

    private int getStress(BlockState state) {
        return (Integer)state.getValue((Property)STRESS);
    }

    private boolean onCooldown(BlockState state) {
        return (Boolean)state.getValue((Property)COOLDOWN);
    }

    private Integer getIteration(BlockState state) {
        return (Integer)state.getValue((Property)ITERATION);
    }
}

