/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.block.dispenser;

import java.util.Iterator;
import net.bunten.enderscape.item.MirrorContext;
import net.bunten.enderscape.item.MirrorItem;
import net.bunten.enderscape.item.MirrorUseChecks;
import net.bunten.enderscape.registry.tag.EnderscapeEntityTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class MirrorDispenserBehavior
extends OptionalDispenseItemBehavior {
    protected ItemStack execute(BlockSource source, ItemStack stack) {
        block0: {
            BlockPos pos;
            Iterator iterator;
            ServerLevel level = source.level();
            MirrorItem.updateLodestoneTracker(stack, (Level)level);
            if (level.isClientSide() || !(iterator = level.getEntitiesOfClass(LivingEntity.class, new AABB(pos = source.pos().relative((Direction)source.state().getValue((Property)DispenserBlock.FACING))), EntitySelector.NO_SPECTATORS.and(entity -> !entity.getType().is(EnderscapeEntityTags.BLACKLISTED_FROM_MIRROR_IN_DISPENSER_TELEPORTATION))).iterator()).hasNext()) break block0;
            LivingEntity mob = (LivingEntity)iterator.next();
            this.setSuccess(MirrorDispenserBehavior.tryTeleport(stack, mob, level));
        }
        return stack;
    }

    private static boolean tryTeleport(ItemStack stack, LivingEntity mob, ServerLevel level) {
        Player player;
        if (mob instanceof Player && (player = (Player)mob).getCooldowns().isOnCooldown(stack.getItem())) {
            return false;
        }
        MirrorContext context = new MirrorContext(stack, (Level)level, mob);
        for (MirrorUseChecks check : MirrorUseChecks.CHECKS_IN_ORDER) {
            if (!check.fails(context)) continue;
            return false;
        }
        return MirrorItem.teleport(context, true);
    }
}

