/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.block.properties;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Direction;

public final class DirectionProperties {
    public static final Codec<DirectionProperties> CODEC = Codec.unit(DirectionProperties::create);
    private final List<Direction> list = new ArrayList<Direction>();

    public static DirectionProperties create() {
        return new DirectionProperties();
    }

    public boolean supports(Direction direction) {
        return this.list.contains(direction);
    }

    private void add(Direction direction) {
        if (!this.list.contains(direction)) {
            this.list.add(direction);
        }
    }

    public DirectionProperties up() {
        this.add(Direction.UP);
        return this;
    }

    public DirectionProperties down() {
        this.add(Direction.DOWN);
        return this;
    }

    public DirectionProperties horizontal() {
        for (Direction direction : Direction.values()) {
            if (direction.getAxis() == Direction.Axis.Y) continue;
            this.add(direction);
        }
        return this;
    }

    public DirectionProperties vertical() {
        this.up();
        this.down();
        return this;
    }

    public DirectionProperties all() {
        this.horizontal();
        this.vertical();
        return this;
    }
}

