/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.block.properties;

import com.mojang.serialization.Codec;
import java.util.function.Supplier;
import net.bunten.enderscape.registry.EnderscapeBlockSounds;
import net.bunten.enderscape.registry.EnderscapeParticles;
import net.bunten.enderscape.registry.tag.EnderscapeBlockTags;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.Block;

public enum MagniaType implements StringRepresentable
{
    ALLURING("alluring", EnderscapeParticles.ALLURING_MAGNIA, EnderscapeBlockSounds.ALLURING_MAGNIA_IDLE, EnderscapeBlockSounds.ALLURING_MAGNIA_SPROUT_MOVE, EnderscapeBlockSounds.ALLURING_MAGNIA_SPROUT_OVERHEAT, EnderscapeBlockSounds.ALLURING_MAGNIA_SPROUT_POWER_OFF, EnderscapeBlockSounds.ALLURING_MAGNIA_SPROUT_POWER_ON, EnderscapeBlockTags.BLOCKS_ALLURING_MAGNIA_SPROUTS),
    REPULSIVE("repulsive", EnderscapeParticles.REPULSIVE_MAGNIA, EnderscapeBlockSounds.REPULSIVE_MAGNIA_IDLE, EnderscapeBlockSounds.REPULSIVE_MAGNIA_SPROUT_MOVE, EnderscapeBlockSounds.REPULSIVE_MAGNIA_SPROUT_OVERHEAT, EnderscapeBlockSounds.REPULSIVE_MAGNIA_SPROUT_POWER_OFF, EnderscapeBlockSounds.REPULSIVE_MAGNIA_SPROUT_POWER_ON, EnderscapeBlockTags.BLOCKS_REPULSIVE_MAGNIA_SPROUTS);

    public static final Codec<MagniaType> CODEC;
    private final String name;
    private final SoundEvent hum;
    private final SoundEvent move;
    private final SoundEvent overheat;
    private final SoundEvent powerOff;
    private final SoundEvent powerOn;
    private final TagKey<Block> blockedByTag;
    private Supplier<? extends ParticleOptions> particle;

    private MagniaType(String name, Supplier<? extends ParticleOptions> particle, SoundEvent hum, SoundEvent move, SoundEvent overheat, SoundEvent powerOff, SoundEvent powerOn, TagKey<Block> blockedByTag) {
        this.name = name;
        this.particle = particle;
        this.hum = hum;
        this.move = move;
        this.overheat = overheat;
        this.powerOff = powerOff;
        this.powerOn = powerOn;
        this.blockedByTag = blockedByTag;
    }

    public String getSerializedName() {
        return this.name;
    }

    public ParticleOptions getParticle() {
        return this.particle.get();
    }

    public SoundEvent getHumSound() {
        return this.hum;
    }

    public SoundEvent getMoveSound() {
        return this.move;
    }

    public SoundEvent getOverheatSound() {
        return this.overheat;
    }

    public SoundEvent getPowerOffSound() {
        return this.powerOff;
    }

    public SoundEvent getPowerOnSound() {
        return this.powerOn;
    }

    public TagKey<Block> getBlockedByTag() {
        return this.blockedByTag;
    }

    static {
        CODEC = StringRepresentable.fromEnum(MagniaType::values);
    }
}

