/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.client;

import com.google.common.reflect.Reflection;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.bunten.enderscape.Enderscape;
import net.bunten.enderscape.client.EnderscapeConfigMenu;
import net.bunten.enderscape.client.block.MagniaSproutRenderer;
import net.bunten.enderscape.client.entity.EndermanStaticSoundInstance;
import net.bunten.enderscape.client.entity.drifter.DrifterModel;
import net.bunten.enderscape.client.entity.drifter.DrifterRenderer;
import net.bunten.enderscape.client.entity.driftlet.DriftletModel;
import net.bunten.enderscape.client.entity.driftlet.DriftletRenderer;
import net.bunten.enderscape.client.entity.rubblemite.RubblemiteModel;
import net.bunten.enderscape.client.entity.rubblemite.RubblemiteRenderer;
import net.bunten.enderscape.client.entity.rustle.RustleModel;
import net.bunten.enderscape.client.entity.rustle.RustleRenderer;
import net.bunten.enderscape.client.hud.HudElement;
import net.bunten.enderscape.client.item.NebuliteToolTooltip;
import net.bunten.enderscape.client.registry.EnderscapeBlockColorProviders;
import net.bunten.enderscape.client.registry.EnderscapeBlockRenderLayerMap;
import net.bunten.enderscape.client.registry.EnderscapeEntityRenderData;
import net.bunten.enderscape.client.registry.EnderscapeHudElements;
import net.bunten.enderscape.client.registry.EnderscapeParticleProviders;
import net.bunten.enderscape.item.MagniaAttractorItem;
import net.bunten.enderscape.item.NebuliteToolComponent;
import net.bunten.enderscape.item.NebuliteToolContext;
import net.bunten.enderscape.item.NebuliteToolItem;
import net.bunten.enderscape.registry.EnderscapeBlockEntities;
import net.bunten.enderscape.registry.EnderscapeEntities;
import net.bunten.enderscape.registry.EnderscapeItems;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.Music;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.Nullable;

@Mod(value="enderscape", dist={Dist.CLIENT})
public class EnderscapeClient {
    public static final List<HudElement> HUD_ELEMENTS = new ArrayList<HudElement>();
    public static Optional<Music> structureMusic = Optional.empty();
    public static final int MAX_STARE_STICKS = 100;
    public static int stareTicks;
    public static int postMirrorUseTicks;
    @Nullable
    public static EndermanStaticSoundInstance staticSoundInstance;

    public static void register(HudElement element) {
        Objects.requireNonNull(element);
        HUD_ELEMENTS.add(element);
    }

    public EnderscapeClient(IEventBus modBus, ModContainer container) {
        Reflection.initialize((Class[])new Class[]{EnderscapeHudElements.class});
        container.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)EnderscapeConfigMenu::buildMenu));
        modBus.addListener(EntityRenderersEvent.RegisterLayerDefinitions.class, event -> {
            event.registerLayerDefinition(EnderscapeEntityRenderData.DRIFTER, DrifterModel::createLayer);
            event.registerLayerDefinition(EnderscapeEntityRenderData.DRIFTLET, DriftletModel::createLayer);
            event.registerLayerDefinition(EnderscapeEntityRenderData.RUBBLEMITE, RubblemiteModel::createLayer);
            event.registerLayerDefinition(EnderscapeEntityRenderData.RUSTLE, RustleModel::createLayer);
        });
        modBus.addListener(EntityRenderersEvent.RegisterRenderers.class, event -> {
            event.registerEntityRenderer((EntityType)EnderscapeEntities.DRIFTER.get(), DrifterRenderer::new);
            event.registerEntityRenderer((EntityType)EnderscapeEntities.DRIFTLET.get(), DriftletRenderer::new);
            event.registerEntityRenderer((EntityType)EnderscapeEntities.RUBBLEMITE.get(), RubblemiteRenderer::new);
            event.registerEntityRenderer((EntityType)EnderscapeEntities.RUSTLE.get(), RustleRenderer::new);
        });
        modBus.register(EnderscapeParticleProviders.class);
        modBus.register(EnderscapeBlockRenderLayerMap.class);
        modBus.register(EnderscapeBlockColorProviders.class);
        modBus.addListener(EntityRenderersEvent.RegisterRenderers.class, event -> event.registerBlockEntityRenderer(EnderscapeBlockEntities.MAGNIA_SPROUT.get(), MagniaSproutRenderer::new));
        modBus.addListener(RegisterClientTooltipComponentFactoriesEvent.class, event -> event.register(NebuliteToolComponent.class, tool -> new NebuliteToolTooltip(tool.stack())));
        modBus.addListener(FMLCommonSetupEvent.class, event -> event.enqueueWork(() -> {
            ClampedItemPropertyFunction shieldFunction = (stack, level, user, i) -> user != null && user.isUsingItem() && user.getUseItem() == stack ? 1.0f : 0.0f;
            ItemProperties.register((Item)EnderscapeItems.END_STONE_RUBBLE_SHIELD.get(), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"blocking"), (ItemPropertyFunction)shieldFunction);
            ItemProperties.register((Item)EnderscapeItems.MIRESTONE_RUBBLE_SHIELD.get(), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"blocking"), (ItemPropertyFunction)shieldFunction);
            ItemProperties.register((Item)EnderscapeItems.VERADITE_RUBBLE_SHIELD.get(), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"blocking"), (ItemPropertyFunction)shieldFunction);
            ItemProperties.register((Item)EnderscapeItems.KURODITE_RUBBLE_SHIELD.get(), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"blocking"), (ItemPropertyFunction)shieldFunction);
            ItemProperties.register((Item)EnderscapeItems.MAGNIA_ATTRACTOR.get(), (ResourceLocation)Enderscape.id("enabled"), (stack, level, user, i) -> MagniaAttractorItem.isEnabled(stack) && NebuliteToolItem.fuelExceedsCost(new NebuliteToolContext(stack, (Level)level, user)) ? 1.0f : 0.0f);
        }));
        modBus.addListener(RegisterGuiLayersEvent.class, event -> {
            for (HudElement element : HUD_ELEMENTS) {
                if (element.phase == HudElement.RenderPhase.BEFORE_HUD) {
                    event.registerBelowAll(element.id, element::render);
                    continue;
                }
                event.registerAboveAll(element.id, element::render);
            }
        });
        NeoForge.EVENT_BUS.addListener(ClientTickEvent.Pre.class, event -> {
            for (HudElement element : HUD_ELEMENTS) {
                element.tick();
            }
        });
    }

    static {
        staticSoundInstance = null;
    }
}

