/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.client;

import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionGroup;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.api.controller.ControllerBuilder;
import dev.isxander.yacl3.api.controller.EnumControllerBuilder;
import dev.isxander.yacl3.api.controller.IntegerSliderControllerBuilder;
import dev.isxander.yacl3.api.controller.TickBoxControllerBuilder;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.bunten.enderscape.Enderscape;
import net.bunten.enderscape.EnderscapeConfig;
import net.bunten.enderscape.client.LightingStyle;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.neoforged.fml.ModContainer;

public class EnderscapeConfigMenu {
    public static Screen buildMenu(ModContainer client, Screen parent) {
        return YetAnotherConfigLib.create(EnderscapeConfig.HANDLER, (defaults, config, builder) -> builder.title((Component)Component.translatable((String)"menu.enderscape.config")).category(EnderscapeConfigMenu.createMainCategory(config)).category(EnderscapeConfigMenu.createClientsideCategory(config))).generateScreen(parent);
    }

    private static <T> Option<T> boolOption(String name, T defaultValue, Supplier<T> getter, Consumer<T> setter, Function<Option<T>, ControllerBuilder<T>> builder) {
        return Option.createBuilder().name((Component)Component.translatable((String)("option.enderscape." + name))).binding(defaultValue, getter, setter).description(OptionDescription.createBuilder().text(new Component[]{Component.translatable((String)("option.enderscape." + name + ".desc"))}).build()).controller(builder).build();
    }

    private static Option<Integer> intOption(String name, int defaultValue, Supplier<Integer> getter, Consumer<Integer> setter, int min, int max, int step) {
        return Option.createBuilder().name((Component)Component.translatable((String)("option.enderscape." + name))).binding((Object)defaultValue, getter, setter).description(OptionDescription.createBuilder().text(new Component[]{Component.translatable((String)("option.enderscape." + name + ".desc"))}).build()).controller(opt -> ((IntegerSliderControllerBuilder)IntegerSliderControllerBuilder.create((Option)opt).range((Number)min, (Number)max)).step((Number)step)).build();
    }

    private static ConfigCategory createMainCategory(EnderscapeConfig config) {
        ConfigCategory.Builder main = ConfigCategory.createBuilder().name((Component)Component.translatable((String)"option.enderscape.category.serverside"));
        EnderscapeConfigMenu.addServersideAmbienceOptions(config, main);
        EnderscapeConfigMenu.addServersideBlockOptions(config, main);
        EnderscapeConfigMenu.addServersideEntityOptions(config, main);
        EnderscapeConfigMenu.addServersideItemOptions(config, main);
        return main.build();
    }

    private static ConfigCategory createClientsideCategory(EnderscapeConfig config) {
        ConfigCategory.Builder main = ConfigCategory.createBuilder().name((Component)Component.translatable((String)"option.enderscape.category.clientside"));
        if (Enderscape.IS_DEBUG) {
            EnderscapeConfigMenu.addDebugOptions(config, main);
        }
        EnderscapeConfigMenu.addClientsideAmbienceOptions(config, main);
        EnderscapeConfigMenu.addClientsideBlockOptions(config, main);
        EnderscapeConfigMenu.addClientsideEntityOptions(config, main);
        EnderscapeConfigMenu.addClientsideItemOptions(config, main);
        if (!Enderscape.IS_DEBUG) {
            EnderscapeConfigMenu.addDebugOptions(config, main);
        }
        return main.build();
    }

    private static void addDebugOptions(EnderscapeConfig config, ConfigCategory.Builder builder) {
        Option<Boolean> debugHudEnabled = EnderscapeConfigMenu.boolOption("debug_hud_enabled", false, () -> config.debugHudEnabled, value -> {
            config.debugHudEnabled = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> debugHudClientInfo = EnderscapeConfigMenu.boolOption("debug_hud_client_info", true, () -> config.debugHudClientInfo, value -> {
            config.debugHudClientInfo = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> debugHudMusicInfo = EnderscapeConfigMenu.boolOption("debug_hud_music_info", true, () -> config.debugHudMusicInfo, value -> {
            config.debugHudMusicInfo = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> debugHudPlayerInfo = EnderscapeConfigMenu.boolOption("debug_hud_player_info", true, () -> config.debugHudPlayerInfo, value -> {
            config.debugHudPlayerInfo = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> debugMagniaSproutHitboxes = EnderscapeConfigMenu.boolOption("debug_magnia_sprout_hitboxes", false, () -> config.debugMagniaSproutHitboxes, value -> {
            config.debugMagniaSproutHitboxes = value;
        }, TickBoxControllerBuilder::create);
        builder.group(OptionGroup.createBuilder().name((Component)Component.translatable((String)"option.group.enderscape.debug")).option(debugHudEnabled).option(debugHudClientInfo).option(debugHudMusicInfo).option(debugHudPlayerInfo).option(debugMagniaSproutHitboxes).build());
    }

    private static void addClientsideAmbienceOptions(EnderscapeConfig config, ConfigCategory.Builder builder) {
        Option<Boolean> skyboxUpdateEnabled = EnderscapeConfigMenu.boolOption("skybox_update_enabled", true, () -> config.skyboxUpdateEnabled, value -> {
            config.skyboxUpdateEnabled = value;
        }, TickBoxControllerBuilder::create);
        Option lightingStyle = Option.createBuilder().name((Component)Component.translatable((String)"option.enderscape.lighting_style")).binding((Object)LightingStyle.IMPROVED, () -> config.lightingStyle, value -> {
            config.lightingStyle = value;
        }).description(OptionDescription.createBuilder().text(new Component[]{Component.translatable((String)"option.enderscape.lighting_style.desc")}).build()).controller(opt -> EnumControllerBuilder.create((Option)opt).enumClass(LightingStyle.class)).build();
        Option<Boolean> skyboxAddDynamicFogDensity = EnderscapeConfigMenu.boolOption("skybox_add_dynamic_fog_density", true, () -> config.skyboxAddDynamicFogDensity, value -> {
            config.skyboxAddDynamicFogDensity = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> skyboxScalesBrightnessWithGamma = EnderscapeConfigMenu.boolOption("skybox_scales_brightness_with_gamma", true, () -> config.skyboxScalesBrightnessWithGamma, value -> {
            config.skyboxScalesBrightnessWithGamma = value;
        }, TickBoxControllerBuilder::create);
        Option<Integer> skyboxBrightnessScaleFactor = EnderscapeConfigMenu.intOption("skybox_brightness_scale_factor", 40, () -> config.skyboxBrightnessScaleFactor, value -> {
            config.skyboxBrightnessScaleFactor = value;
        }, 10, 100, 1);
        builder.group(OptionGroup.createBuilder().name((Component)Component.translatable((String)"option.group.enderscape.ambience")).option(skyboxUpdateEnabled).option(skyboxScalesBrightnessWithGamma).option(skyboxBrightnessScaleFactor).option(skyboxAddDynamicFogDensity).option(lightingStyle).build());
    }

    private static void addServersideAmbienceOptions(EnderscapeConfig config, ConfigCategory.Builder builder) {
        Option<Boolean> updateDefaultEndMusic = EnderscapeConfigMenu.boolOption("ambience_update_default_music", true, () -> config.ambienceUpdateDefaultMusic, value -> {
            config.ambienceUpdateDefaultMusic = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> updateDefaultEndLoop = EnderscapeConfigMenu.boolOption("ambience_update_default_loop", true, () -> config.ambienceUpdateDefaultLoop, value -> {
            config.ambienceUpdateDefaultLoop = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> updateDefaultEndAdditions = EnderscapeConfigMenu.boolOption("ambience_update_default_additions", true, () -> config.ambienceUpdateDefaultAdditions, value -> {
            config.ambienceUpdateDefaultAdditions = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> updateDefaultEndMood = EnderscapeConfigMenu.boolOption("ambience_update_default_mood", true, () -> config.ambienceUpdateDefaultMood, value -> {
            config.ambienceUpdateDefaultMood = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> updateDefaultEndParticles = EnderscapeConfigMenu.boolOption("ambience_update_default_particles", true, () -> config.ambienceUpdateDefaultParticles, value -> {
            config.ambienceUpdateDefaultParticles = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> updateDefaultEndSkyColor = EnderscapeConfigMenu.boolOption("ambience_update_default_sky_color", true, () -> config.ambienceUpdateDefaultSkyColor, value -> {
            config.ambienceUpdateDefaultSkyColor = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> updateDefaultEndFogColor = EnderscapeConfigMenu.boolOption("ambience_update_default_fog_color", true, () -> config.ambienceUpdateDefaultFogColor, value -> {
            config.ambienceUpdateDefaultFogColor = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> updateDefaultEndGrassColor = EnderscapeConfigMenu.boolOption("ambience_update_default_grass_color", true, () -> config.ambienceUpdateDefaultGrassColor, value -> {
            config.ambienceUpdateDefaultGrassColor = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> updateDefaultEndFoliageColor = EnderscapeConfigMenu.boolOption("ambience_update_default_foliage_color", true, () -> config.ambienceUpdateDefaultFoliageColor, value -> {
            config.ambienceUpdateDefaultFoliageColor = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> updateDefaultEndWaterColor = EnderscapeConfigMenu.boolOption("ambience_update_default_water_color", true, () -> config.ambienceUpdateDefaultWaterColor, value -> {
            config.ambienceUpdateDefaultWaterColor = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> updateDefaultEndWaterFogColor = EnderscapeConfigMenu.boolOption("ambience_update_default_water_fog_color", true, () -> config.ambienceUpdateDefaultWaterFogColor, value -> {
            config.ambienceUpdateDefaultWaterFogColor = value;
        }, TickBoxControllerBuilder::create);
        builder.group(OptionGroup.createBuilder().name((Component)Component.translatable((String)"option.group.enderscape.ambience")).option(updateDefaultEndMusic).option(updateDefaultEndLoop).option(updateDefaultEndAdditions).option(updateDefaultEndMood).option(updateDefaultEndSkyColor).option(updateDefaultEndFogColor).option(updateDefaultEndGrassColor).option(updateDefaultEndFoliageColor).option(updateDefaultEndWaterColor).option(updateDefaultEndWaterFogColor).option(updateDefaultEndParticles).build());
    }

    private static void addServersideBlockOptions(EnderscapeConfig config, ConfigCategory.Builder builder) {
        Option<Boolean> blockSoundsUpdateChorus = EnderscapeConfigMenu.boolOption("block_sounds_update_chorus", true, () -> config.blockSoundUpdateChorus, value -> {
            config.blockSoundUpdateChorus = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> blocksSoundUpdatePurpur = EnderscapeConfigMenu.boolOption("block_sounds_update_purpur", true, () -> config.blockSoundUpdatePurpur, value -> {
            config.blockSoundUpdatePurpur = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> blockSoundUpdateEndPortalFrame = EnderscapeConfigMenu.boolOption("block_sounds_update_end_portal_frame", true, () -> config.blockSoundUpdateEndPortalFrame, value -> {
            config.blockSoundUpdateEndPortalFrame = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> blockSoundUpdateEndPortals = EnderscapeConfigMenu.boolOption("block_sounds_update_end_portals", true, () -> config.blockSoundUpdateEndPortals, value -> {
            config.blockSoundUpdateEndPortals = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> blockSoundsUpdateEndRods = EnderscapeConfigMenu.boolOption("block_sounds_update_end_rods", true, () -> config.blockSoundUpdateEndRods, value -> {
            config.blockSoundUpdateEndRods = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> blockSoundUpdateEndStone = EnderscapeConfigMenu.boolOption("block_sounds_update_end_stone", true, () -> config.blockSoundUpdateEndStone, value -> {
            config.blockSoundUpdateEndStone = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> blockSoundUpdateEndStoneBricks = EnderscapeConfigMenu.boolOption("block_sounds_update_end_stone_bricks", true, () -> config.blockSoundUpdateEndStoneBricks, value -> {
            config.blockSoundUpdateEndStoneBricks = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> blockSoundUpdateShulkerBoxes = EnderscapeConfigMenu.boolOption("block_sounds_update_shulker_boxes", true, () -> config.blockSoundUpdateShulkerBoxes, value -> {
            config.blockSoundUpdateShulkerBoxes = value;
        }, TickBoxControllerBuilder::create);
        builder.group(OptionGroup.createBuilder().name((Component)Component.translatable((String)"option.group.enderscape.blocks")).option(blockSoundsUpdateChorus).option(blockSoundUpdateEndPortalFrame).option(blockSoundUpdateEndPortals).option(blockSoundsUpdateEndRods).option(blockSoundUpdateEndStoneBricks).option(blockSoundUpdateEndStone).option(blocksSoundUpdatePurpur).option(blockSoundUpdateShulkerBoxes).build());
    }

    private static void addClientsideBlockOptions(EnderscapeConfig config, ConfigCategory.Builder builder) {
        Option<Boolean> chorusFlowerHumming = EnderscapeConfigMenu.boolOption("chorus_flower_humming", true, () -> config.chorusFlowerHumming, value -> {
            config.chorusFlowerHumming = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> chorusFlowerPollen = EnderscapeConfigMenu.boolOption("chorus_flower_pollen", true, () -> config.chorusFlowerPollen, value -> {
            config.chorusFlowerPollen = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> endPortalUpdateParticles = EnderscapeConfigMenu.boolOption("end_portal_update_particles", true, () -> config.endPortalUpdateParticles, value -> {
            config.endPortalUpdateParticles = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> endPortalUpdateTravelSound = EnderscapeConfigMenu.boolOption("end_portal_update_travel_sound", true, () -> config.endPortalUpdateTravelSound, value -> {
            config.endPortalUpdateTravelSound = value;
        }, TickBoxControllerBuilder::create);
        builder.group(OptionGroup.createBuilder().name((Component)Component.translatable((String)"option.group.enderscape.blocks")).option(chorusFlowerHumming).option(chorusFlowerPollen).option(endPortalUpdateParticles).option(endPortalUpdateTravelSound).build());
    }

    private static void addServersideEntityOptions(EnderscapeConfig config, ConfigCategory.Builder builder) {
        Option<Boolean> endermanStereoStareSound = EnderscapeConfigMenu.boolOption("enderman_stereo_stare_sound", true, () -> config.endermanStereoStareSound, value -> {
            config.endermanStereoStareSound = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> endermiteExpandHitRange = EnderscapeConfigMenu.boolOption("endermite_expand_hit_range", true, () -> config.endermiteExpandHitRange, value -> {
            config.endermiteExpandHitRange = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> endermiteUpdateSounds = EnderscapeConfigMenu.boolOption("endermite_update_sounds", true, () -> config.endermiteUpdateSounds, value -> {
            config.endermiteUpdateSounds = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> rubblemiteExpandHitRange = EnderscapeConfigMenu.boolOption("rubblemite_expand_hit_range", true, () -> config.rubblemiteExpandHitRange, value -> {
            config.rubblemiteExpandHitRange = value;
        }, TickBoxControllerBuilder::create);
        Option<Integer> shulkerBulletEnforceTimeLimit = EnderscapeConfigMenu.intOption("shulker_bullet_enforce_time_limit", 30, () -> config.shulkerBulletEnforceTimeLimit, value -> {
            config.shulkerBulletEnforceTimeLimit = value;
        }, 0, 60, 1);
        Option<Integer> shulkerBulletEnforceDistanceLimit = EnderscapeConfigMenu.intOption("shulker_bullet_enforce_distance_limit", 30, () -> config.shulkerBulletEnforceDistanceLimit, value -> {
            config.shulkerBulletEnforceDistanceLimit = value;
        }, 0, 100, 1);
        Option<Boolean> shulkerBulletEnforceOwnerLimit = EnderscapeConfigMenu.boolOption("shulker_bullet_enforce_owner_limit", true, () -> config.shulkerBulletEnforceOwnerLimit, value -> {
            config.shulkerBulletEnforceOwnerLimit = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> shulkerBulletRebalanceLevitation = EnderscapeConfigMenu.boolOption("shulker_bullet_rebalance_levitation", true, () -> config.shulkerBulletRebalanceLevitation, value -> {
            config.shulkerBulletRebalanceLevitation = value;
        }, TickBoxControllerBuilder::create);
        Option<Integer> shulkerBulletEnforceCountLimit = EnderscapeConfigMenu.intOption("shulker_bullet_enforce_count_limit", 3, () -> config.shulkerBulletEnforceCountLimit, value -> {
            config.shulkerBulletEnforceCountLimit = value;
        }, 0, 8, 1);
        Option<Boolean> shulkerHurtByPiercing = EnderscapeConfigMenu.boolOption("shulker_hurt_by_piercing", true, () -> config.shulkerHurtByPiercing, value -> {
            config.shulkerHurtByPiercing = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> silverfishExpandHitRange = EnderscapeConfigMenu.boolOption("silverfish_expand_hit_range", true, () -> config.silverfishExpandHitRange, value -> {
            config.silverfishExpandHitRange = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> voidPoofParticlesUponDeath = EnderscapeConfigMenu.boolOption("void_poof_particles_upon_death", true, () -> config.voidPoofParticlesUponDeath, value -> {
            config.voidPoofParticlesUponDeath = value;
        }, TickBoxControllerBuilder::create);
        builder.group(OptionGroup.createBuilder().name((Component)Component.translatable((String)"option.group.enderscape.entity")).option(endermanStereoStareSound).option(endermiteExpandHitRange).option(endermiteUpdateSounds).option(rubblemiteExpandHitRange).option(shulkerBulletEnforceCountLimit).option(shulkerBulletEnforceDistanceLimit).option(shulkerBulletEnforceOwnerLimit).option(shulkerBulletEnforceTimeLimit).option(shulkerBulletRebalanceLevitation).option(shulkerHurtByPiercing).option(silverfishExpandHitRange).option(voidPoofParticlesUponDeath).build());
    }

    private static void addClientsideEntityOptions(EnderscapeConfig config, ConfigCategory.Builder builder) {
        Option<Boolean> portalParticleEmissive = EnderscapeConfigMenu.boolOption("portal_particle_emissive", true, () -> config.portalParticleEmissive, value -> {
            config.portalParticleEmissive = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> endermiteEmissiveEyes = EnderscapeConfigMenu.boolOption("endermite_emissive_eyes", true, () -> config.endermiteEmissiveEyes, value -> {
            config.endermiteEmissiveEyes = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> shulkerBulletLoopSound = EnderscapeConfigMenu.boolOption("shulker_bullet_loop_sound", true, () -> config.shulkerBulletLoopSound, value -> {
            config.shulkerBulletLoopSound = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> endermanStaticSound = EnderscapeConfigMenu.boolOption("enderman_static_sound", true, () -> config.endermanStaticSound, value -> {
            config.endermanStaticSound = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> endermanStaticOverlay = EnderscapeConfigMenu.boolOption("enderman_static_overlay", true, () -> config.endermanStaticOverlay, value -> {
            config.endermanStaticOverlay = value;
        }, TickBoxControllerBuilder::create);
        builder.group(OptionGroup.createBuilder().name((Component)Component.translatable((String)"option.group.enderscape.entity")).option(endermanStaticOverlay).option(endermanStaticSound).option(endermiteEmissiveEyes).option(portalParticleEmissive).option(shulkerBulletLoopSound).build());
    }

    private static void addServersideItemOptions(EnderscapeConfig config, ConfigCategory.Builder builder) {
        Option<Boolean> elytraAddOpenCloseSounds = EnderscapeConfigMenu.boolOption("elytra_add_open_close_sounds", true, () -> config.elytraAddOpenCloseSounds, value -> {
            config.elytraAddOpenCloseSounds = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> elytraSneakToStopGliding = EnderscapeConfigMenu.boolOption("elytra_sneak_to_stop_gliding", true, () -> config.elytraSneakToStopGliding, value -> {
            config.elytraSneakToStopGliding = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> elytraUpdateEquipSound = EnderscapeConfigMenu.boolOption("elytra_update_equip_sound", true, () -> config.elytraUpdateEquipSound, value -> {
            config.elytraUpdateEquipSound = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> enderPearlBreakParticles = EnderscapeConfigMenu.boolOption("ender_pearl_break_particles", true, () -> config.enderPearlBreakParticles, value -> {
            config.enderPearlBreakParticles = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> enderPearlUpdateTeleportSound = EnderscapeConfigMenu.boolOption("ender_pearl_update_teleport_sound", true, () -> config.enderPearlUpdateTeleportSound, value -> {
            config.enderPearlUpdateTeleportSound = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> enderPearlUpdateThrowSound = EnderscapeConfigMenu.boolOption("ender_pearl_update_throw_sound", true, () -> config.enderPearlUpdateThrowSound, value -> {
            config.enderPearlUpdateThrowSound = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> tridentsReturnFromVoid = EnderscapeConfigMenu.boolOption("tridents_return_from_void", true, () -> config.tridentsReturnFromVoid, value -> {
            config.tridentsReturnFromVoid = value;
        }, TickBoxControllerBuilder::create);
        builder.group(OptionGroup.createBuilder().name((Component)Component.translatable((String)"option.group.enderscape.item")).option(elytraAddOpenCloseSounds).option(elytraSneakToStopGliding).option(elytraUpdateEquipSound).option(enderPearlBreakParticles).option(enderPearlUpdateTeleportSound).option(enderPearlUpdateThrowSound).option(tridentsReturnFromVoid).build());
    }

    private static void addClientsideItemOptions(EnderscapeConfig config, ConfigCategory.Builder builder) {
        Option<Boolean> elytraAddGlidingSound = EnderscapeConfigMenu.boolOption("elytra_add_gliding_sound", true, () -> config.elytraAddGlidingSound, value -> {
            config.elytraAddGlidingSound = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> elytraAddFovEffects = EnderscapeConfigMenu.boolOption("elytra_add_fov_effects", true, () -> config.elytraAddFovEffects, value -> {
            config.elytraAddFovEffects = value;
        }, TickBoxControllerBuilder::create);
        Option<Integer> elytraFovEffectIntensity = EnderscapeConfigMenu.intOption("elytra_fov_effect_intensity", 100, () -> config.elytraFovEffectIntensity, value -> {
            config.elytraFovEffectIntensity = value;
        }, 0, 200, 1);
        Option<Boolean> enderPearlAddParticles = EnderscapeConfigMenu.boolOption("ender_pearl_add_particles", true, () -> config.enderPearlAddParticles, value -> {
            config.enderPearlAddParticles = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> mirrorTooltipEnabled = EnderscapeConfigMenu.boolOption("mirror_tooltip_enabled", true, () -> config.mirrorTooltipEnabled, value -> {
            config.mirrorTooltipEnabled = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> mirrorTooltipDisplayCoordinates = EnderscapeConfigMenu.boolOption("mirror_tooltip_display_coordinates", false, () -> config.mirrorTooltipDisplayCoordinates, value -> {
            config.mirrorTooltipDisplayCoordinates = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> mirrorTooltipDisplayDimension = EnderscapeConfigMenu.boolOption("mirror_tooltip_display_dimension", true, () -> config.mirrorTooltipDisplayDimension, value -> {
            config.mirrorTooltipDisplayDimension = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> mirrorTooltipDisplayDistance = EnderscapeConfigMenu.boolOption("mirror_tooltip_display_distance", true, () -> config.mirrorTooltipDisplayDistance, value -> {
            config.mirrorTooltipDisplayDistance = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> mirrorTooltipShiftToDisplay = EnderscapeConfigMenu.boolOption("mirror_tooltip_shift_to_display", false, () -> config.mirrorTooltipShiftToDisplay, value -> {
            config.mirrorTooltipShiftToDisplay = value;
        }, TickBoxControllerBuilder::create);
        Option<Boolean> mirrorScreenEffectEnabled = EnderscapeConfigMenu.boolOption("mirror_screen_effect_enabled", true, () -> config.mirrorScreenEffectEnabled, value -> {
            config.mirrorScreenEffectEnabled = value;
        }, TickBoxControllerBuilder::create);
        Option<Integer> mirrorScreenEffectOverlayIntensity = EnderscapeConfigMenu.intOption("mirror_screen_effect_overlay_intensity", 50, () -> config.mirrorScreenEffectOverlayIntensity, value -> {
            config.mirrorScreenEffectOverlayIntensity = value;
        }, 0, 100, 1);
        Option<Integer> mirrorScreenEffectVignetteIntensity = EnderscapeConfigMenu.intOption("mirror_screen_effect_vignette_intensity", 50, () -> config.mirrorScreenEffectVignetteIntensity, value -> {
            config.mirrorScreenEffectVignetteIntensity = value;
        }, 0, 100, 1);
        Option<Boolean> nebuliteToolHudEnabled = EnderscapeConfigMenu.boolOption("nebulite_tool_hud_enabled", true, () -> config.nebuliteToolHudEnabled, value -> {
            config.nebuliteToolHudEnabled = value;
        }, TickBoxControllerBuilder::create);
        Option<Integer> nebuliteToolHudOffset = EnderscapeConfigMenu.intOption("nebulite_tool_hud_offset", 0, () -> config.nebuliteToolHudOffset, value -> {
            config.nebuliteToolHudOffset = value;
        }, 0, 50, 1);
        Option<Integer> nebuliteToolHudOpacity = EnderscapeConfigMenu.intOption("nebulite_tool_hud_opacity", 100, () -> config.nebuliteToolHudOpacity, value -> {
            config.nebuliteToolHudOpacity = value;
        }, 10, 100, 1);
        builder.group(OptionGroup.createBuilder().name((Component)Component.translatable((String)"option.group.enderscape.item")).option(elytraAddFovEffects).option(elytraFovEffectIntensity).option(elytraAddGlidingSound).option(enderPearlAddParticles).option(mirrorTooltipEnabled).option(mirrorTooltipShiftToDisplay).option(mirrorTooltipDisplayCoordinates).option(mirrorTooltipDisplayDimension).option(mirrorTooltipDisplayDistance).option(mirrorScreenEffectEnabled).option(mirrorScreenEffectOverlayIntensity).option(mirrorScreenEffectVignetteIntensity).option(nebuliteToolHudEnabled).option(nebuliteToolHudOffset).option(nebuliteToolHudOpacity).build());
    }
}

