/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.client.entity;

import net.bunten.enderscape.registry.EnderscapeItemSounds;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;

public class ElytraSoundInstance
extends AbstractTickableSoundInstance {
    private final Player player;
    private int time;

    public ElytraSoundInstance(Player player) {
        super(EnderscapeItemSounds.ELYTRA_GLIDING.get(), SoundSource.PLAYERS, SoundInstance.createUnseededRandom());
        this.player = player;
        this.looping = true;
        this.delay = 0;
        this.volume = 0.1f;
    }

    public void tick() {
        ++this.time;
        if (this.player.isRemoved() || this.time > 20 && !this.player.isFallFlying()) {
            this.stop();
            return;
        }
        this.x = (float)this.player.getX();
        this.y = (float)this.player.getY();
        this.z = (float)this.player.getZ();
        float movementSpeed = (float)this.player.getDeltaMovement().lengthSqr();
        float f = this.volume = (double)movementSpeed >= 1.0E-7 ? Mth.clamp((float)(movementSpeed / 4.0f), (float)0.0f, (float)1.0f) : 0.0f;
        if (this.time < 20) {
            this.volume = 0.0f;
        } else if (this.time < 40) {
            this.volume *= (float)(this.time - 20) / 20.0f;
        }
        this.pitch = this.volume > 0.8f ? 1.0f + (this.volume - 0.8f) : 1.0f;
    }
}

