/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.client.entity;

import net.bunten.enderscape.registry.EnderscapeEntitySounds;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.EnderMan;

public class EndermanStareSoundInstance
extends AbstractTickableSoundInstance {
    private final Minecraft client;
    private final int entityId;

    public EndermanStareSoundInstance(Minecraft client, int entityId) {
        super(EnderscapeEntitySounds.ENDERMAN_STARE_STEREO.get(), SoundSource.HOSTILE, SoundInstance.createUnseededRandom());
        this.client = client;
        this.entityId = entityId;
        this.delay = 5;
        this.volume = 1.0f;
        this.pitch = 1.0f;
    }

    public void tick() {
        if (this.client.level == null || Minecraft.getInstance().level == null || this.volume < 0.01f) {
            this.stop();
        } else if (!this.canPlay()) {
            this.volume = Mth.lerp((float)0.1f, (float)this.volume, (float)0.0f);
            this.pitch = Mth.lerp((float)this.volume, (float)0.8f, (float)1.0f);
        }
    }

    private boolean canPlay() {
        EnderMan enderman;
        Entity entity;
        return this.client.level != null && (entity = this.client.level.getEntity(this.entityId)) instanceof EnderMan && (enderman = (EnderMan)entity).isAlive() && enderman.isCreepy();
    }
}

