/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.client.entity;

import net.bunten.enderscape.client.EnderscapeClient;
import net.bunten.enderscape.registry.EnderscapeEntitySounds;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;

public class EndermanStaticSoundInstance
extends AbstractTickableSoundInstance {
    private final Minecraft client;

    public EndermanStaticSoundInstance(Minecraft client) {
        super(EnderscapeEntitySounds.ENDERMAN_STATIC.get(), SoundSource.HOSTILE, SoundInstance.createUnseededRandom());
        this.client = client;
        this.looping = true;
        this.delay = 0;
        this.pitch = 0.96f;
        this.volume = 0.02f;
    }

    public void tick() {
        float target;
        if (this.client.level == null || this.volume < 0.01f) {
            this.remove();
        }
        float lerpFactor = this.volume < (target = Mth.clamp((float)((float)EnderscapeClient.stareTicks / 33.333332f), (float)0.0f, (float)1.0f)) ? 0.04f : 0.2f;
        this.volume = Mth.lerp((float)lerpFactor, (float)this.volume, (float)target);
        this.pitch = Mth.lerp((float)this.volume, (float)0.96f, (float)1.0f);
    }

    private void remove() {
        this.stop();
        EnderscapeClient.staticSoundInstance = null;
    }
}

