/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.client.entity.driftlet;

import net.bunten.enderscape.entity.drifter.Driftlet;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class DriftletModel
extends HierarchicalModel<Driftlet> {
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart leftLeg;
    private final ModelPart rightLeg;
    private final ModelPart stem;
    private final ModelPart bell;
    private final ModelPart strandsN;
    private final ModelPart strandsW;
    private final ModelPart strandsS;
    private final ModelPart strandsE;

    public DriftletModel(ModelPart root) {
        this.root = root;
        this.head = root.getChild("head");
        this.leftLeg = this.head.getChild("leftLeg");
        this.rightLeg = this.head.getChild("rightLeg");
        this.stem = this.head.getChild("stem");
        this.bell = this.stem.getChild("bell");
        this.strandsN = this.bell.getChild("strandsN");
        this.strandsW = this.bell.getChild("strandsW");
        this.strandsS = this.bell.getChild("strandsS");
        this.strandsE = this.bell.getChild("strandsE");
    }

    public ModelPart root() {
        return this.root;
    }

    public static LayerDefinition createLayer() {
        CubeDeformation dilation = CubeDeformation.NONE;
        MeshDefinition data = new MeshDefinition();
        PartDefinition rootData = data.getRoot();
        PartDefinition headData = rootData.addOrReplaceChild("head", CubeListBuilder.create().texOffs(32, 24).addBox(-4.0f, -7.0f, -4.0f, 8.0f, 7.0f, 8.0f, dilation), PartPose.offset((float)0.0f, (float)20.0f, (float)0.0f));
        headData.addOrReplaceChild("leftLeg", CubeListBuilder.create().texOffs(48, 7).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 4.0f, 3.0f, dilation), PartPose.offset((float)1.5f, (float)0.0f, (float)-0.5f));
        headData.addOrReplaceChild("rightLeg", CubeListBuilder.create().texOffs(48, 0).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 4.0f, 3.0f, dilation), PartPose.offset((float)-1.5f, (float)0.0f, (float)-0.5f));
        PartDefinition stemData = headData.addOrReplaceChild("stem", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, -6.0f, -2.0f, 4.0f, 6.0f, 4.0f, dilation), PartPose.offset((float)0.0f, (float)-7.0f, (float)0.0f));
        PartDefinition bellData = stemData.addOrReplaceChild("bell", CubeListBuilder.create().texOffs(0, 0).addBox(-8.0f, -8.0f, -8.0f, 16.0f, 8.0f, 16.0f, dilation), PartPose.offset((float)0.0f, (float)-2.0f, (float)0.0f));
        CubeListBuilder strandBuilder = CubeListBuilder.create().texOffs(0, 24).addBox(-8.0f, 0.0f, 0.0f, 16.0f, 12.0f, 0.0f, dilation);
        bellData.addOrReplaceChild("strandsN", strandBuilder, PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-7.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        bellData.addOrReplaceChild("strandsW", strandBuilder, PartPose.offsetAndRotation((float)7.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        bellData.addOrReplaceChild("strandsS", strandBuilder, PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)7.0f, (float)0.0f, (float)3.1416f, (float)0.0f));
        bellData.addOrReplaceChild("strandsE", strandBuilder, PartPose.offsetAndRotation((float)-7.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.5708f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)data, (int)64, (int)48);
    }

    public void setupAnim(Driftlet mob, float animPos, float animSpeed, float age, float headYaw, float headPitch) {
        animPos = (float)((double)animPos * 0.5);
        animSpeed = (float)((double)animSpeed * 0.5);
        this.head.yRot = headYaw * ((float)Math.PI / 180);
        this.head.xRot = headPitch * ((float)Math.PI / 180) + Mth.sin((float)(age * 0.2f)) * 0.1f;
        this.head.zRot = 0.1f * Mth.sin((float)(animPos * 0.8f)) * 2.0f * (animSpeed * 0.25f);
        this.head.xRot += 0.1f * Mth.sin((float)(animPos * 0.8f)) * 4.0f * (animSpeed * 0.25f);
        this.stem.xRot = -this.head.xRot;
        this.bell.xRot = Mth.sin((float)(age * 0.2f + 1.5707964f)) * 0.1f;
        this.bell.zRot = 0.1f * -(Mth.sin((float)(animPos * 0.8f)) * 3.0f * (animSpeed * 0.5f));
        this.strandsN.xRot = -(this.head.xRot * 0.1f) + Mth.sin((float)(age * 0.1f + 1.5707964f)) * 0.3f;
        this.strandsN.xRot += 0.2f * Mth.sin((float)(animPos * 0.8f)) * (animSpeed * 0.5f);
        this.strandsW.xRot = this.strandsN.xRot;
        this.strandsS.xRot = this.strandsN.xRot;
        this.strandsE.xRot = this.strandsN.xRot;
        this.leftLeg.xRot = this.head.xRot / 2.0f + Mth.cos((float)(animPos * 0.6662f + 1.5707964f)) * 0.6f * animSpeed;
        this.rightLeg.xRot = this.head.xRot / 2.0f + Mth.cos((float)(animPos * 0.6662f)) * 0.6f * animSpeed;
        this.leftLeg.xRot += Mth.sin((float)(age * 0.2f)) * 0.4f;
        this.rightLeg.xRot += Mth.sin((float)(age * 0.2f + 1.5707964f)) * 0.4f;
        this.leftLeg.zRot = -this.head.zRot + 0.1f * Mth.sin((float)(animPos * 0.4f + 1.5707964f)) * 4.0f * (animSpeed * 0.5f);
        this.rightLeg.zRot = -this.head.zRot + 0.1f * Mth.sin((float)(animPos * 0.4f)) * 4.0f * (animSpeed * 0.5f);
    }
}

