/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.client.entity.rubblemite;

import net.bunten.enderscape.entity.rubblemite.Rubblemite;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class RubblemiteModel
extends HierarchicalModel<Rubblemite> {
    private final ModelPart shell;
    private final ModelPart head;
    private final ModelPart root;

    public RubblemiteModel(ModelPart root) {
        this.root = root;
        this.shell = root.getChild("shell");
        this.head = this.shell.getChild("head");
    }

    public ModelPart root() {
        return this.root;
    }

    public static LayerDefinition createLayer() {
        CubeDeformation dilation = CubeDeformation.NONE;
        MeshDefinition data = new MeshDefinition();
        PartDefinition rootData = data.getRoot();
        PartDefinition shellData = rootData.addOrReplaceChild("shell", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -6.0f, -4.0f, 8.0f, 6.0f, 8.0f, dilation), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        shellData.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 14).addBox(-2.0f, -2.0f, -1.0f, 4.0f, 4.0f, 1.0f, dilation), PartPose.offset((float)0.0f, (float)-2.0f, (float)-4.0f));
        return LayerDefinition.create((MeshDefinition)data, (int)32, (int)32);
    }

    public void setupAnim(Rubblemite mob, float animPos, float animSpeed, float age, float headYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        float strength = 0.05f;
        float speed = 0.3f;
        float speed2 = speed * 2.0f;
        if (mob.isDashing()) {
            this.shell.yRot = age;
        } else {
            this.head.xRot = -Mth.sin((float)(age * speed)) * strength;
            this.head.zRot = -Mth.sin((float)(age * speed2 + 1.5707964f)) * strength;
            this.shell.xRot = Mth.sin((float)(age * speed + 1.5707964f)) * strength;
            this.shell.zRot = Mth.sin((float)(age * speed2)) * strength;
            this.shell.xRot += headPitch * ((float)Math.PI / 180) / 2.0f;
            this.shell.yRot += headYaw * ((float)Math.PI / 180) / 2.0f;
        }
        this.head.visible = !mob.isInsideShell() && !mob.isDashing();
    }
}

