/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.client.entity.rustle;

import net.bunten.enderscape.client.entity.rustle.RustleAnimations;
import net.bunten.enderscape.entity.rustle.Rustle;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class RustleModel
extends HierarchicalModel<Rustle> {
    private final ModelPart body;
    private final ModelPart crossSpines;
    private final ModelPart middleSpines;
    private final ModelPart backSpines;
    private final ModelPart head;
    private final ModelPart rightAntenna;
    private final ModelPart leftAntenna;
    private final ModelPart frontSpines;
    private final ModelPart root;

    public RustleModel(ModelPart root) {
        this.root = root;
        this.body = root.getChild("body");
        this.crossSpines = this.body.getChild("crossSpines");
        this.middleSpines = this.body.getChild("middleSpines");
        this.backSpines = this.body.getChild("backSpines");
        this.head = root.getChild("head");
        this.rightAntenna = this.head.getChild("rightAntenna");
        this.leftAntenna = this.head.getChild("leftAntenna");
        this.frontSpines = this.head.getChild("frontSpines");
    }

    public ModelPart root() {
        return this.root;
    }

    public static LayerDefinition createLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -2.5f, -5.0f, 8.0f, 5.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)21.5f, (float)2.0f));
        PartDefinition crossSpines = body.addOrReplaceChild("crossSpines", CubeListBuilder.create().texOffs(0, 27).addBox(-7.0f, -2.5f, 0.0f, 14.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-5.0f, (float)0.0f, (float)0.0f, (float)0.7854f, (float)0.0f));
        crossSpines.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(0, 27).addBox(-7.0f, -1.0f, 0.0f, 14.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-1.5f, (float)0.0f, (float)0.0f, (float)1.5708f, (float)0.0f));
        body.addOrReplaceChild("middleSpines", CubeListBuilder.create().texOffs(0, 20).addBox(-7.0f, -4.0f, 0.0f, 14.0f, 7.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-0.5f, (float)-2.0f));
        body.addOrReplaceChild("backSpines", CubeListBuilder.create().texOffs(0, 20).addBox(-7.0f, -4.0f, 0.0f, 14.0f, 7.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-0.5f, (float)3.0f));
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(26, 0).addBox(-3.0f, -2.5f, -3.0f, 6.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)21.5f, (float)-4.0f));
        head.addOrReplaceChild("rightAntenna", CubeListBuilder.create().texOffs(46, -7).addBox(0.0f, -7.0f, -5.5f, 0.0f, 7.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)-2.5f, (float)-1.5f));
        head.addOrReplaceChild("leftAntenna", CubeListBuilder.create().texOffs(46, -7).addBox(0.0f, -7.0f, -5.5f, 0.0f, 7.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)-2.5f, (float)-1.5f));
        head.addOrReplaceChild("frontSpines", CubeListBuilder.create().texOffs(0, 15).addBox(-7.0f, -2.0f, 0.0f, 14.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-0.5f, (float)-2.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void setupAnim(Rustle mob, float animPos, float animSpeed, float age, float headYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.leftAntenna.yRot = Mth.sin((float)(age + animPos / 3.0f * 0.1f)) * animSpeed * 0.3f;
        this.rightAntenna.yRot = Mth.sin((float)(age + animPos / 3.0f * 0.1f + 1.5707964f)) * animSpeed * 0.8f;
        this.leftAntenna.xRot = Mth.sin((float)(age + animPos / 3.0f * 0.1f + 1.5707964f)) * animSpeed * 0.8f;
        this.rightAntenna.xRot = Mth.sin((float)(age + animPos / 3.0f * 0.1f + 4.712389f)) * animSpeed * 0.8f;
        this.head.xRot = headPitch * ((float)Math.PI / 180) / 2.0f;
        this.head.yRot = headYaw * ((float)Math.PI / 180) / 2.0f;
        this.head.zRot = Mth.sin((float)(age + animPos / 3.0f * 0.06f)) * animSpeed * 0.5f;
        this.body.zRot = Mth.sin((float)(age + animPos / 3.0f * 0.03f)) * animSpeed * 0.25f;
        this.frontSpines.yRot = Mth.sin((float)(age + animPos / 3.0f * 0.1f)) * animSpeed * 0.8f;
        this.middleSpines.yRot = Mth.sin((float)(age + animPos / 3.0f * 0.1f + 1.5707964f)) * animSpeed * 0.8f;
        this.backSpines.yRot = Mth.sin((float)(age + animPos / 3.0f * 0.1f + (float)Math.PI)) * animSpeed * 0.8f;
        this.animate(mob.sleepingAnimationState, RustleAnimations.SLEEPING, age, 1.0f);
        this.head.xScale = mob.isBaby() ? 1.25f : 1.0f;
        this.head.yScale = mob.isBaby() ? 1.25f : 1.0f;
        this.head.zScale = mob.isBaby() ? 1.25f : 1.0f;
        this.crossSpines.visible = !mob.isBaby() && !mob.isSheared();
    }
}

