/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.client.hud;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.bunten.enderscape.Enderscape;
import net.bunten.enderscape.client.EnderscapeClient;
import net.bunten.enderscape.client.hud.HudElement;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LightLayer;

public class MirrorScreenEffect
extends HudElement {
    public static final ResourceLocation OVERLAY_TEXTURE = Enderscape.id("textures/misc/overlay.png");
    public static final ResourceLocation VIGNETTE_TEXTURE = Enderscape.id("textures/misc/vignette.png");

    public MirrorScreenEffect() {
        super(Enderscape.id("mirror_screen"), HudElement.RenderPhase.BEFORE_HUD);
    }

    @Override
    public void render(GuiGraphics graphics, DeltaTracker delta) {
        if (Minecraft.getInstance().player == null || Minecraft.getInstance().options.hideGui || !Minecraft.getInstance().options.getCameraType().isFirstPerson() || Minecraft.getInstance().player.isSpectator() || EnderscapeClient.postMirrorUseTicks <= 0 || !this.config.mirrorScreenEffectEnabled) {
            return;
        }
        graphics.pose().pushPose();
        float light = Math.max(0.3f, (float)Minecraft.getInstance().level.getBrightness(LightLayer.SKY, Minecraft.getInstance().player.blockPosition()) / 15.0f);
        float overlayAlpha = Mth.clamp((float)((float)EnderscapeClient.postMirrorUseTicks / 40.0f * ((float)this.config.mirrorScreenEffectOverlayIntensity / 100.0f) * light), (float)0.0f, (float)1.0f);
        float vignetteAlpha = Mth.clamp((float)((float)EnderscapeClient.postMirrorUseTicks / 60.0f * ((float)this.config.mirrorScreenEffectVignetteIntensity / 100.0f) * light), (float)0.0f, (float)1.0f);
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_CONSTANT_ALPHA);
        graphics.setColor(1.0f, 1.0f, 1.0f, overlayAlpha);
        graphics.blit(OVERLAY_TEXTURE, 0, 0, 0.0f, 0.0f, graphics.guiWidth(), graphics.guiHeight(), graphics.guiWidth(), graphics.guiHeight());
        graphics.setColor(1.0f, 1.0f, 1.0f, vignetteAlpha);
        graphics.blit(VIGNETTE_TEXTURE, 0, 0, 0.0f, 0.0f, graphics.guiWidth(), graphics.guiHeight(), graphics.guiWidth(), graphics.guiHeight());
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableBlend();
        graphics.pose().popPose();
    }

    @Override
    public void tick() {
        super.tick();
        if (EnderscapeClient.postMirrorUseTicks > 0 && !Minecraft.getInstance().isPaused()) {
            --EnderscapeClient.postMirrorUseTicks;
        }
    }
}

