/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.client.hud;

import net.bunten.enderscape.Enderscape;
import net.bunten.enderscape.client.hud.HudElement;
import net.bunten.enderscape.item.MirrorContext;
import net.bunten.enderscape.item.MirrorItem;
import net.bunten.enderscape.item.NebuliteToolContext;
import net.bunten.enderscape.item.NebuliteToolItem;
import net.bunten.enderscape.util.NineSliceBlitUtil;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class NebuliteToolHud
extends HudElement {
    private static final ResourceLocation[] EMPTY_SEGMENTS = new ResourceLocation[]{Enderscape.id("nebulite_tool/hud/empty_segments/start"), Enderscape.id("nebulite_tool/hud/empty_segments/loop"), Enderscape.id("nebulite_tool/hud/empty_segments/end")};
    private static final ResourceLocation[] FUELED_SEGMENTS = new ResourceLocation[]{Enderscape.id("nebulite_tool/hud/fueled_segments/start"), Enderscape.id("nebulite_tool/hud/fueled_segments/loop"), Enderscape.id("nebulite_tool/hud/fueled_segments/end")};
    private static final ResourceLocation[] INVALID_OVERLAY_SEGMENTS = new ResourceLocation[]{Enderscape.id("nebulite_tool/hud/invalid_overlay_segments/start"), Enderscape.id("nebulite_tool/hud/invalid_overlay_segments/loop"), Enderscape.id("nebulite_tool/hud/invalid_overlay_segments/end")};
    private static final ResourceLocation TRANSDIMENSIONAL_OUTLINE = Enderscape.id("nebulite_tool/hud/transdimensional_outline");
    private static final ResourceLocation COST_OVERLAY_SEGMENT = Enderscape.id("nebulite_tool/hud/cost_overlay_segment");
    private float heightOffset = 0.0f;
    private float totalAlpha = 0.0f;
    private float costAlpha = 0.0f;
    private int costDisplayTicks = 0;
    private float invalidAlpha = 0.0f;
    private int invalidDisplayTicks = 0;
    private float transdimensionalAlpha = 0.0f;
    private int transdimensionalDisplayTicks = 0;
    private int costOverlayPosition = -1;
    private int fuel;
    private int maxFuel;
    private int cost;

    public NebuliteToolHud() {
        super(Enderscape.id("nebulite_tool"), HudElement.RenderPhase.AFTER_HUD);
    }

    @Override
    public void render(GuiGraphics graphics, DeltaTracker delta) {
        if (!this.config.nebuliteToolHudEnabled || Minecraft.getInstance().player == null || Minecraft.getInstance().options.hideGui || this.totalAlpha <= 0.01f || !Minecraft.getInstance().options.getCameraType().isFirstPerson() || Minecraft.getInstance().player.isSpectator()) {
            return;
        }
        graphics.pose().pushPose();
        graphics.pose().translate(0.0f, this.heightOffset, 0.0f);
        float opacity = this.totalAlpha * (float)this.config.nebuliteToolHudOpacity / 100.0f;
        int x = graphics.guiWidth() / 2 - (11 * this.maxFuel + 1) / 2;
        int y = graphics.guiHeight() / 2 - 13 - this.config.nebuliteToolHudOffset;
        this.renderFuelBar(graphics, x, y, opacity);
        this.renderTransdimensionalOutline(graphics, x, y, opacity);
        this.renderInvalidOverlay(graphics, x, y, opacity);
        this.renderCostOverlay(graphics, y, opacity);
        graphics.pose().popPose();
    }

    private void renderFuelBar(GuiGraphics graphics, int x, int y, float opacity) {
        int lastFueled = -1;
        int rx = x;
        for (int i = 0; i < this.maxFuel; ++i) {
            ResourceLocation[] segments;
            boolean isFueled;
            boolean bl = isFueled = i < this.fuel;
            if (i > 0) {
                rx += 11;
            }
            if (isFueled) {
                lastFueled = rx;
            }
            ResourceLocation[] resourceLocationArray = segments = isFueled ? FUELED_SEGMENTS : EMPTY_SEGMENTS;
            int index = i == 0 ? 0 : (i == this.maxFuel - 1 ? 2 : 1);
            int width = i == this.maxFuel - 1 ? 12 : 11;
            TextureAtlasSprite sprite = Minecraft.getInstance().getGuiSprites().getSprite(segments[index]);
            graphics.blit(rx, y, 0, width, 5, sprite, 1.0f, 1.0f, 1.0f, opacity);
        }
        this.costOverlayPosition = lastFueled;
    }

    private void renderTransdimensionalOutline(GuiGraphics graphics, int x, int y, float opacity) {
        NineSliceBlitUtil nineSliceBlit = new NineSliceBlitUtil(Minecraft.getInstance().getGuiSprites(), graphics, this.transdimensionalAlpha * opacity);
        nineSliceBlit.blitSprite(TRANSDIMENSIONAL_OUTLINE, x - 6, y - 6, 0, this.maxFuel * 11 + 13, 17);
    }

    private void renderInvalidOverlay(GuiGraphics graphics, int x, int y, float opacity) {
        int rx = x;
        for (int i = 0; i < this.maxFuel; ++i) {
            if (i > 0) {
                rx += 11;
            }
            int index = i == 0 ? 0 : (i == this.maxFuel - 1 ? 2 : 1);
            int width = i == this.maxFuel - 1 ? 12 : 11;
            TextureAtlasSprite sprite = Minecraft.getInstance().getGuiSprites().getSprite(INVALID_OVERLAY_SEGMENTS[index]);
            graphics.blit(rx, y, 0, width, 5, sprite, 1.0f, 1.0f, 1.0f, this.invalidAlpha * opacity);
        }
    }

    private void renderCostOverlay(GuiGraphics graphics, int y, float opacity) {
        if (this.costAlpha > 0.0f && this.costOverlayPosition >= 0 && this.fuel >= this.cost) {
            for (int i = 0; i < this.cost; ++i) {
                TextureAtlasSprite sprite = Minecraft.getInstance().getGuiSprites().getSprite(COST_OVERLAY_SEGMENT);
                graphics.blit(this.costOverlayPosition - i * 11, y, 0, 11, 5, sprite, 1.0f, 1.0f, 1.0f, this.costAlpha * opacity);
            }
        }
    }

    @Override
    public void tick() {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        ItemStack stack = NebuliteToolItem.is(player.getMainHandItem()) ? player.getMainHandItem() : player.getOffhandItem();
        NebuliteToolContext context = new NebuliteToolContext(stack, player.level(), (LivingEntity)player);
        boolean displayUI = NebuliteToolItem.is(stack) && context.item().displayHudWhen(context) && !player.isSpectator() && player.getUseItem().isEmpty();
        boolean displayOutline = NebuliteToolItem.is(stack) && !context.item().hideInvalidOutlineWhen(context);
        boolean displayTransdimensional = false;
        if (MirrorItem.is(stack)) {
            MirrorContext mirrorContext = MirrorContext.of(context);
            boolean bl = displayTransdimensional = MirrorItem.hasTransdimensional(mirrorContext) && !MirrorItem.isSameDimension(mirrorContext, mirrorContext.linkedDimension()) && !displayOutline;
        }
        if (displayUI) {
            this.fuel = NebuliteToolItem.currentFuel(stack);
            this.maxFuel = NebuliteToolItem.maxFuel(stack);
            this.cost = NebuliteToolItem.of(stack).fuelCost(context);
            this.totalAlpha = Mth.lerp((float)0.5f, (float)this.totalAlpha, (float)1.0f);
            this.heightOffset = Mth.lerp((float)0.5f, (float)this.heightOffset, (float)-3.0f);
        } else {
            this.totalAlpha = Mth.lerp((float)0.5f, (float)this.totalAlpha, (float)0.0f);
            this.heightOffset = Mth.lerp((float)0.5f, (float)this.heightOffset, (float)0.0f);
        }
        this.invalidAlpha = Mth.lerp((float)0.35f, (float)this.invalidAlpha, (float)(displayUI && displayOutline ? Mth.clamp((float)(Mth.sin((float)((float)this.invalidDisplayTicks * 0.4f)) * 0.5f + 0.5f), (float)0.75f, (float)1.0f) : 0.0f));
        this.costAlpha = Mth.lerp((float)0.35f, (float)this.costAlpha, (float)(displayUI && !displayOutline ? Mth.clamp((float)(Mth.sin((float)((float)this.costDisplayTicks * 0.25f)) * 0.2f + 0.5f), (float)0.75f, (float)1.0f) : 0.0f));
        this.transdimensionalAlpha = Mth.lerp((float)0.35f, (float)this.transdimensionalAlpha, (float)(displayUI && displayTransdimensional ? Mth.clamp((float)(Mth.sin((float)((float)this.transdimensionalDisplayTicks * 0.1f)) * 0.5f + 0.5f), (float)0.4f, (float)1.0f) : 0.0f));
        this.invalidDisplayTicks = this.invalidAlpha > 0.0f ? this.invalidDisplayTicks + 1 : 0;
        this.costDisplayTicks = this.costAlpha > 0.0f ? this.costDisplayTicks + 1 : 0;
        this.transdimensionalDisplayTicks = this.transdimensionalAlpha > 0.0f ? this.transdimensionalDisplayTicks + 1 : 0;
    }
}

