/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.client.hud;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.bunten.enderscape.Enderscape;
import net.bunten.enderscape.EnderscapeConfig;
import net.bunten.enderscape.client.EnderscapeClient;
import net.bunten.enderscape.client.hud.HudElement;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class StareScreenEffect
extends HudElement {
    public static final ResourceLocation STATIC_TEXTURE = Enderscape.id("textures/misc/static.png");

    public StareScreenEffect() {
        super(Enderscape.id("stare_screen"), HudElement.RenderPhase.BEFORE_HUD);
    }

    @Override
    public void render(GuiGraphics graphics, DeltaTracker delta) {
        if (Minecraft.getInstance().player == null || Minecraft.getInstance().options.hideGui || !Minecraft.getInstance().options.getCameraType().isFirstPerson() || Minecraft.getInstance().player.isSpectator() || EnderscapeClient.stareTicks <= 0 || !EnderscapeConfig.getInstance().endermanStaticOverlay) {
            return;
        }
        graphics.pose().pushPose();
        float alpha = Mth.clamp((float)((float)EnderscapeClient.stareTicks / 100.0f), (float)0.0f, (float)0.25f);
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_CONSTANT_ALPHA);
        graphics.setColor(1.0f, 1.0f, 1.0f, alpha);
        graphics.blit(STATIC_TEXTURE, 0, 0, Minecraft.getInstance().player.getRandom().nextInt(graphics.guiWidth() / 2), Minecraft.getInstance().player.getRandom().nextInt(graphics.guiHeight() / 2), graphics.guiWidth(), graphics.guiHeight());
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableBlend();
        graphics.pose().popPose();
    }

    @Override
    public void tick() {
        super.tick();
        if (EnderscapeClient.stareTicks > 0 && !Minecraft.getInstance().isPaused()) {
            --EnderscapeClient.stareTicks;
        }
    }
}

