/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.client.item;

import net.bunten.enderscape.Enderscape;
import net.bunten.enderscape.item.NebuliteToolItem;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class NebuliteToolTooltip
implements ClientTooltipComponent {
    private static final ResourceLocation[] EMPTY_SEGMENTS = new ResourceLocation[]{Enderscape.id("nebulite_tool/tooltip/empty_segments/start"), Enderscape.id("nebulite_tool/tooltip/empty_segments/loop"), Enderscape.id("nebulite_tool/tooltip/empty_segments/end")};
    private static final ResourceLocation FUELED_SEGMENT = Enderscape.id("nebulite_tool/tooltip/fueled_segment");
    private final ItemStack stack;

    public NebuliteToolTooltip(ItemStack stack) {
        this.stack = stack;
        if (!(stack.getItem() instanceof NebuliteToolItem)) {
            throw new IllegalStateException("Item is not an instance of " + String.valueOf(NebuliteToolItem.class) + ", unapplicable for " + String.valueOf(NebuliteToolTooltip.class));
        }
    }

    public int getHeight() {
        return 12;
    }

    public int getWidth(Font font) {
        return this.getBarWidth();
    }

    public void renderImage(Font font, int x, int y, GuiGraphics graphics) {
        this.renderFuelBar(graphics, x, y + 1);
    }

    private int getBarWidth() {
        return 32 + 11 * (NebuliteToolItem.maxFuel(this.stack) - 2);
    }

    private void renderFuelBar(GuiGraphics graphics, int x, int y) {
        int rx = x;
        int fuel = NebuliteToolItem.currentFuel(this.stack);
        int maxFuel = NebuliteToolItem.maxFuel(this.stack);
        for (int i = 0; i < maxFuel; ++i) {
            int index;
            boolean isFueled;
            boolean bl = isFueled = i < fuel;
            int n = i == 0 ? 0 : (index = i == maxFuel - 1 ? 2 : 1);
            int width = i == 0 ? 20 : (i == maxFuel - 1 ? 12 : 11);
            int offsetY = i == 0 ? -2 : 0;
            int spriteHeight = i == 0 ? 10 : 6;
            graphics.blitSprite(EMPTY_SEGMENTS[index], rx += i == 0 ? 0 : (i == 1 ? 20 : 11), y + offsetY, width, spriteHeight);
            if (!isFueled) continue;
            graphics.blitSprite(FUELED_SEGMENT, rx + (i == 0 ? 9 : 0), y, 11, 6);
        }
    }
}

