/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.client.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.mojang.authlib.GameProfile;
import net.bunten.enderscape.EnderscapeConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={AbstractClientPlayer.class})
public abstract class AbstractClientPlayerMixin
extends Player {
    @Unique
    private int Enderscape$elytraFlightTime = 0;

    public AbstractClientPlayerMixin(Level level, BlockPos blockPos, float f, GameProfile gameProfile) {
        super(level, blockPos, f, gameProfile);
    }

    @Unique
    private float Enderscape$getElytraFovIntensity() {
        float configIntensity = (float)EnderscapeConfig.getInstance().elytraFovEffectIntensity / 100.0f;
        return (float)((double)configIntensity * (Double)Minecraft.getInstance().options.fovEffectScale().get());
    }

    @Unique
    private float Enderscape$getElytraFovModifier() {
        float fovModifier = 1.0f;
        if (this.isFallFlying()) {
            ++this.Enderscape$elytraFlightTime;
            if (this.isRemoved() || this.Enderscape$elytraFlightTime > 20 && !this.isFallFlying()) {
                return fovModifier;
            }
            float speed = (float)this.getDeltaMovement().lengthSqr();
            float factor = Mth.clamp((float)(speed / 20.0f), (float)0.0f, (float)1.5f) * this.Enderscape$getElytraFovIntensity();
            if (this.Enderscape$elytraFlightTime < 20) {
                return fovModifier;
            }
            fovModifier = this.Enderscape$elytraFlightTime < 40 ? 1.0f + (float)(this.Enderscape$elytraFlightTime - 20) / 20.0f * factor : 1.0f + factor;
        }
        return Mth.clamp((float)fovModifier, (float)1.0f, (float)1.5f);
    }

    @ModifyReturnValue(method={"getFieldOfViewModifier"}, at={@At(value="RETURN")})
    private float getFieldOfViewModifier(float original) {
        if (EnderscapeConfig.getInstance().elytraAddFovEffects) {
            return original * this.Enderscape$getElytraFovModifier();
        }
        return original;
    }
}

