/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.client.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import net.bunten.enderscape.EnderscapeConfig;
import net.bunten.enderscape.client.world.EnderscapeSkybox;
import net.bunten.enderscape.entity.EndTrialSpawnable;
import net.bunten.enderscape.registry.EnderscapeBlockSounds;
import net.bunten.enderscape.registry.EnderscapeBlocks;
import net.bunten.enderscape.registry.EnderscapeParticles;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.vault.VaultBlockEntity;
import net.minecraft.world.level.block.entity.vault.VaultSharedData;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArgs;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.invoke.arg.Args;

@Mixin(value={LevelRenderer.class})
public abstract class LevelRendererMixin {
    @Shadow
    private ClientLevel level;

    @Inject(method={"renderEndSky"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderEndSky(PoseStack pose, CallbackInfo ci) {
        if (EnderscapeConfig.getInstance().skyboxUpdateEnabled) {
            EnderscapeSkybox.render(pose, this.level, Minecraft.getInstance().gameRenderer.getMainCamera(), Minecraft.getInstance().getTimer());
            ci.cancel();
        }
    }

    @ModifyArgs(method={"levelEvent"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/resources/sounds/SimpleSoundInstance;forLocalAmbience(Lnet/minecraft/sounds/SoundEvent;FF)Lnet/minecraft/client/resources/sounds/SimpleSoundInstance;"))
    public void levelEvent(Args args) {
        if (EnderscapeConfig.getInstance().endPortalUpdateTravelSound && this.level.dimension() == Level.END) {
            args.set(0, (Object)EnderscapeBlockSounds.END_PORTAL_TRAVEL);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"levelEvent"}, cancellable=true)
    public void Enderscape$tryToStartFallFlying(int eventID, BlockPos pos, int extraID, CallbackInfo ci) {
        double zd;
        double yd;
        double xd;
        double z;
        double y;
        RandomSource random = this.level.getRandom();
        if (eventID == 3015 && this.level.getBlockState(pos).is(EnderscapeBlocks.END_VAULT.get())) {
            BlockEntity blockEntity = this.level.getBlockEntity(pos);
            if (blockEntity instanceof VaultBlockEntity) {
                VaultBlockEntity entity = (VaultBlockEntity)blockEntity;
                VaultBlockEntity.Client.emitActivationParticles((Level)this.level, (BlockPos)entity.getBlockPos(), (BlockState)entity.getBlockState(), (VaultSharedData)entity.getSharedData(), (ParticleOptions)((ParticleOptions)EnderscapeParticles.VOID_STARS.get()));
                this.level.playLocalSound(pos, EnderscapeBlockSounds.END_VAULT_ACTIVATE, SoundSource.BLOCKS, 1.0f, Mth.nextFloat((RandomSource)random, (float)0.8f, (float)1.2f), true);
            }
            ci.cancel();
        }
        if (eventID == 3016 && this.level.getBlockState(pos).is(EnderscapeBlocks.END_VAULT.get())) {
            VaultBlockEntity.Client.emitDeactivationParticles((Level)this.level, (BlockPos)pos, (ParticleOptions)((ParticleOptions)EnderscapeParticles.VOID_STARS.get()));
            this.level.playLocalSound(pos, EnderscapeBlockSounds.END_VAULT_DEACTIVATE, SoundSource.BLOCKS, 1.0f, Mth.nextFloat((RandomSource)random, (float)0.8f, (float)1.2f), true);
            ci.cancel();
        }
        if (eventID == 3017 && this.level.getBlockState(pos).is(EnderscapeBlocks.END_VAULT.get())) {
            for (int b = 0; b < 20; ++b) {
                double x = (double)pos.getX() + 0.4 + random.nextDouble() * 0.2;
                y = (double)pos.getY() + 0.4 + random.nextDouble() * 0.2;
                z = (double)pos.getZ() + 0.4 + random.nextDouble() * 0.2;
                xd = random.nextGaussian() * 0.02;
                yd = random.nextGaussian() * 0.02;
                zd = random.nextGaussian() * 0.02;
                this.level.addParticle((ParticleOptions)EnderscapeParticles.VOID_STARS.get(), x, y, z, xd, yd, zd * 0.25);
                this.level.addParticle((ParticleOptions)ParticleTypes.REVERSE_PORTAL, x, y, z, xd, yd, zd);
            }
            ci.cancel();
        }
        if (eventID == 3011 && this.level.getBlockState(pos).is(EnderscapeBlocks.END_TRIAL_SPAWNER.get())) {
            for (int i = 0; i < 20; ++i) {
                double x = (double)pos.getX() + 0.5 + (random.nextDouble() - 0.5) * 2.0;
                y = (double)pos.getY() + 0.5 + (random.nextDouble() - 0.5) * 2.0;
                z = (double)pos.getZ() + 0.5 + (random.nextDouble() - 0.5) * 2.0;
                this.level.addParticle((ParticleOptions)ParticleTypes.REVERSE_PORTAL, x, y, z, 0.0, 0.0, 0.0);
                this.level.addParticle((ParticleOptions)EnderscapeParticles.VOID_STARS.get(), x, y, z, 0.0, 0.0, 0.0);
            }
            ci.cancel();
        }
        if (eventID == 3012 && !this.level.getEntitiesOfClass(Mob.class, new AABB(pos), EndTrialSpawnable::spawnedFromEndTrialSpawner).isEmpty()) {
            this.level.playLocalSound(pos, SoundEvents.TRIAL_SPAWNER_SPAWN_MOB, SoundSource.BLOCKS, 1.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f, true);
            for (int i = 0; i < 20; ++i) {
                double x = (double)pos.getX() + 0.5 + (random.nextDouble() - 0.5) * 2.0;
                y = (double)pos.getY() + 0.5 + (random.nextDouble() - 0.5) * 2.0;
                z = (double)pos.getZ() + 0.5 + (random.nextDouble() - 0.5) * 2.0;
                this.level.addParticle((ParticleOptions)ParticleTypes.REVERSE_PORTAL, x, y, z, 0.0, 0.0, 0.0);
                this.level.addParticle((ParticleOptions)EnderscapeParticles.VOID_STARS.get(), x, y, z, 0.0, 0.0, 0.0);
            }
            ci.cancel();
        }
        if (eventID == 3021 && this.level.getBlockState(pos).is(EnderscapeBlocks.END_TRIAL_SPAWNER.get())) {
            this.level.playLocalSound(pos, SoundEvents.TRIAL_SPAWNER_SPAWN_ITEM, SoundSource.BLOCKS, 1.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f, true);
            for (int i = 0; i < 20; ++i) {
                double x = (double)pos.getX() + 0.5 + (random.nextDouble() - 0.5) * 2.0;
                y = (double)pos.getY() + 0.5 + (random.nextDouble() - 0.5) * 2.0;
                z = (double)pos.getZ() + 0.5 + (random.nextDouble() - 0.5) * 2.0;
                this.level.addParticle((ParticleOptions)ParticleTypes.REVERSE_PORTAL, x, y, z, 0.0, 0.0, 0.0);
                this.level.addParticle((ParticleOptions)EnderscapeParticles.VOID_STARS.get(), x, y, z, 0.0, 0.0, 0.0);
            }
            ci.cancel();
        }
        if (eventID == 3013 && this.level.getBlockState(pos).is(EnderscapeBlocks.END_TRIAL_SPAWNER.get())) {
            this.level.playLocalSound(pos, SoundEvents.TRIAL_SPAWNER_DETECT_PLAYER, SoundSource.BLOCKS, 1.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f, true);
            for (int j = 0; j < 30 + Math.min(j, 10) * 5; ++j) {
                double x = (double)pos.getX() + 0.5 + (double)(2.0f * random.nextFloat() - 1.0f) * 0.65;
                y = (double)pos.getY() + 0.1 + (double)random.nextFloat() * 0.8;
                z = (double)pos.getZ() + 0.5 + (double)(2.0f * random.nextFloat() - 1.0f) * 0.65;
                this.level.addParticle((ParticleOptions)EnderscapeParticles.END_TRIAL_SPAWNER_DETECTION.get(), x, y, z, 0.0, 0.0, 0.0);
            }
            ci.cancel();
        }
        if (eventID == 3014 && this.level.getBlockState(pos).is(EnderscapeBlocks.END_TRIAL_SPAWNER.get())) {
            this.level.playLocalSound(pos, SoundEvents.TRIAL_SPAWNER_EJECT_ITEM, SoundSource.BLOCKS, 1.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f, true);
            for (int i = 0; i < 20; ++i) {
                double x = (double)pos.getX() + 0.4 + random.nextDouble() * 0.2;
                y = (double)pos.getY() + 0.4 + random.nextDouble() * 0.2;
                z = (double)pos.getZ() + 0.4 + random.nextDouble() * 0.2;
                xd = random.nextGaussian() * 0.02;
                yd = random.nextGaussian() * 0.02;
                zd = random.nextGaussian() * 0.02;
                this.level.addParticle((ParticleOptions)EnderscapeParticles.VOID_STARS.get(), x, y, z, xd, yd, zd * 0.25);
                this.level.addParticle((ParticleOptions)ParticleTypes.REVERSE_PORTAL, x, y, z, xd, yd, zd);
            }
            ci.cancel();
        }
        if (eventID == 3017 && this.level.getBlockState(pos).is(EnderscapeBlocks.END_TRIAL_SPAWNER.get())) {
            for (int i = 0; i < 20; ++i) {
                double x = (double)pos.getX() + 0.4 + random.nextDouble() * 0.2;
                y = (double)pos.getY() + 0.4 + random.nextDouble() * 0.2;
                z = (double)pos.getZ() + 0.4 + random.nextDouble() * 0.2;
                xd = random.nextGaussian() * 0.02;
                yd = random.nextGaussian() * 0.02;
                zd = random.nextGaussian() * 0.02;
                this.level.addParticle((ParticleOptions)EnderscapeParticles.VOID_STARS.get(), x, y, z, xd, yd, zd * 0.25);
                this.level.addParticle((ParticleOptions)ParticleTypes.REVERSE_PORTAL, x, y, z, xd, yd, zd);
            }
            ci.cancel();
        }
    }
}

