/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.client.mixin;

import net.bunten.enderscape.EnderscapeConfig;
import net.bunten.enderscape.client.LightingStyle;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArgs;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.invoke.arg.Args;

@Mixin(value={LightTexture.class})
public abstract class LightTextureMixin {
    @Shadow
    @Final
    private Minecraft minecraft;

    @Unique
    private boolean Enderscape$shouldUpdateLighting(LightingStyle style) {
        return this.minecraft.level != null && this.minecraft.level.dimension() == Level.END && EnderscapeConfig.getInstance().lightingStyle == style;
    }

    @ModifyArgs(method={"updateLightTexture(F)V"}, at=@At(value="INVOKE", target="Lorg/joml/Vector3f;set(FFF)Lorg/joml/Vector3f;"))
    private void changeBlockLightColor(Args args) {
        if (this.Enderscape$shouldUpdateLighting(LightingStyle.IMPROVED) || this.Enderscape$shouldUpdateLighting(LightingStyle.MIDNIGHT)) {
            float r = ((Float)args.get(0)).floatValue();
            float g = ((Float)args.get(1)).floatValue();
            float b = ((Float)args.get(2)).floatValue();
            g = Mth.clamp((float)(g - r * 0.1f), (float)0.0f, (float)1.0f);
            b = Mth.clamp((float)(b + r * 0.16f), (float)0.0f, (float)1.0f);
            args.set(0, (Object)Float.valueOf(r));
            args.set(1, (Object)Float.valueOf(g));
            args.set(2, (Object)Float.valueOf(b));
        }
    }

    @Redirect(method={"updateLightTexture"}, at=@At(value="INVOKE", target="Lorg/joml/Vector3f;lerp(Lorg/joml/Vector3fc;F)Lorg/joml/Vector3f;", ordinal=1))
    private Vector3f changeEndLighting(Vector3f instance, Vector3fc other, float t) {
        if (this.Enderscape$shouldUpdateLighting(LightingStyle.IMPROVED)) {
            return instance.lerp((Vector3fc)new Vector3f(0.93f, 1.1f, 0.93f), 0.1f);
        }
        if (this.Enderscape$shouldUpdateLighting(LightingStyle.MIDNIGHT)) {
            return instance.lerp((Vector3fc)new Vector3f(0.93f, 1.1f, 0.93f), 0.01f);
        }
        return instance.lerp(other, t);
    }

    @ModifyArgs(method={"updateLightTexture"}, at=@At(value="INVOKE", target="Lorg/joml/Vector3f;lerp(Lorg/joml/Vector3fc;F)Lorg/joml/Vector3f;", ordinal=5))
    private void fixGamma(Args args) {
        if (this.Enderscape$shouldUpdateLighting(LightingStyle.IMPROVED) || this.Enderscape$shouldUpdateLighting(LightingStyle.MIDNIGHT)) {
            Float value = (Float)args.get(1);
            args.set(1, (Object)Float.valueOf(value.floatValue() * 0.75f));
        }
    }
}

