/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.client.mixin;

import java.util.Optional;
import net.bunten.enderscape.client.EnderscapeClient;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.WinScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.Musics;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Minecraft.class})
public abstract class MinecraftMixin {
    @Shadow
    static Minecraft instance;

    @Inject(method={"getSituationalMusic"}, at={@At(value="HEAD")}, cancellable=true)
    public void getSituationalMusic(CallbackInfoReturnable<Music> info) {
        if (MinecraftMixin.instance.screen instanceof WinScreen && !instance.getMusicManager().isPlayingMusic(Musics.CREDITS)) {
            instance.getSoundManager().stop();
        }
        LocalPlayer player = MinecraftMixin.instance.player;
        ClientLevel level = MinecraftMixin.instance.level;
        if (player != null && level.dimension() == Level.END) {
            Optional optional;
            Biome biome = (Biome)level.getBiome(player.blockPosition()).value();
            Optional optional2 = optional = EnderscapeClient.structureMusic.isPresent() ? EnderscapeClient.structureMusic : biome.getBackgroundMusic();
            if (optional.isPresent()) {
                Music music = (Music)optional.get();
                info.setReturnValue((Object)music);
            }
        }
    }
}

