/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;

public class CelestialSporesParticle
extends TextureSheetParticle {
    protected CelestialSporesParticle(ClientLevel level, double x, double y, double z, double xd, double yd, double zd, SpriteSet sprites) {
        super(level, x, y, z, xd, yd, zd);
        this.setSpriteFromAge(sprites);
        this.hasPhysics = true;
        this.gravity = -0.05f;
        this.lifetime = 40;
        this.quadSize = 0.02f;
    }

    public void tick() {
        float sin = Mth.sin((float)((float)this.age * 0.4f)) * 0.01f;
        this.xd += (double)sin;
        this.zd += (double)sin;
        if (this.alpha > 0.25f) {
            this.alpha -= 0.0075f;
        } else {
            this.remove();
        }
        super.tick();
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    protected int getLightColor(float delta) {
        return Math.max(20, super.getLightColor(delta));
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Provider(SpriteSet sprites) {
            this.sprites = sprites;
        }

        public Particle createParticle(SimpleParticleType parameters, ClientLevel level, double x, double y, double z, double xd, double yd, double zd) {
            return new CelestialSporesParticle(level, x, y, z, xd, yd, zd, this.sprites);
        }
    }
}

