/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;

public class ChorusPollenParticle
extends TextureSheetParticle {
    protected ChorusPollenParticle(ClientLevel level, double x, double y, double z, double xd, double yd, double zd, SpriteSet sprites) {
        super(level, x, y, z);
        this.setSpriteFromAge(sprites);
        this.hasPhysics = true;
        this.lifetime = Mth.nextInt((RandomSource)this.random, (int)80, (int)100);
        this.quadSize = Mth.nextFloat((RandomSource)this.random, (float)0.12f, (float)0.18f);
        this.xd = xd;
        this.yd = yd;
        this.zd = zd;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    protected int getLightColor(float tint) {
        return Math.max(60, super.getLightColor(tint));
    }

    public void tick() {
        if (this.age > this.lifetime / 2) {
            if (this.alpha > 0.1f) {
                this.alpha -= 0.015f;
            } else {
                this.remove();
            }
        }
        super.tick();
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Provider(SpriteSet sprites) {
            this.sprites = sprites;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xd, double yd, double zd) {
            return new ChorusPollenParticle(level, x, y, z, xd, yd, zd, this.sprites);
        }
    }
}

