/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.client.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;

public class CorruptSporesParticle
extends TextureSheetParticle {
    protected CorruptSporesParticle(ClientLevel level, double x, double y, double z, double xd, double yd, double zd, SpriteSet sprites) {
        super(level, x, y, z, xd, yd, zd);
        this.setSpriteFromAge(sprites);
        this.alpha = 0.0f;
        this.hasPhysics = true;
        this.gravity = -0.005f;
        this.lifetime = 120;
        this.quadSize = 0.015f;
    }

    public void tick() {
        this.xd += (double)(Mth.sin((float)((float)this.age * 0.4f)) * 0.01f);
        this.zd += (double)(Mth.sin((float)((float)this.age * 0.4f + (float)Math.PI)) * 0.01f);
        float newAlpha = 0.0f;
        BlockPos pos = BlockPos.containing((double)this.x, (double)this.y, (double)this.z);
        if (this.level.getChunk(pos) != null) {
            newAlpha = (float)this.level.getChunkSource().getLightEngine().getRawBrightness(pos, 0) / 15.0f;
        }
        this.alpha = Mth.lerp((float)0.15f, (float)this.alpha, (float)newAlpha);
        super.tick();
    }

    public int getLightColor(float delta) {
        return 255;
    }

    public void render(VertexConsumer consumer, Camera camera, float f) {
        if (this.alpha >= 0.1f) {
            super.render(consumer, camera, f);
        }
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Provider(SpriteSet sprites) {
            this.sprites = sprites;
        }

        public Particle createParticle(SimpleParticleType parameters, ClientLevel level, double x, double y, double z, double xd, double yd, double zd) {
            return new CorruptSporesParticle(level, x, y, z, xd, yd, zd, this.sprites);
        }
    }
}

