/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.client.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.bunten.enderscape.particle.DashJumpShockwaveParticleOptions;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class DashJumpShockwaveParticle
extends TextureSheetParticle {
    private final SpriteSet sprites;
    private final DashJumpShockwaveParticleOptions options;
    protected float decayRate;
    protected float spinSpeed;

    public DashJumpShockwaveParticle(ClientLevel level, double x, double y, double z, SpriteSet sprites, DashJumpShockwaveParticleOptions options) {
        super(level, x, y, z);
        this.sprites = sprites;
        this.options = options;
        Vector3f velocity = options.velocity();
        this.xd = velocity.x();
        this.yd = velocity.y();
        this.zd = velocity.z();
        this.hasPhysics = true;
        this.gravity = 0.0f;
        this.friction = 0.9f;
        this.alpha = 1.0f;
        Vec3 color = Vec3.fromRGB24((int)0xA3FFFF);
        this.rCol = (float)color.x;
        this.gCol = (float)color.y;
        this.bCol = (float)color.z;
        this.lifetime = 30;
        this.quadSize = 3.0f * options.scale();
        this.decayRate = 0.09f;
        this.spinSpeed = 0.0f;
        this.setSpriteFromAge(sprites);
    }

    public void tick() {
        super.tick();
        this.alpha = Mth.lerp((float)this.decayRate, (float)this.alpha, (float)0.0f);
        if (this.alpha < 0.01f) {
            this.remove();
        }
        this.setSpriteFromAge(this.sprites);
    }

    public void render(VertexConsumer consumer, Camera camera, float delta) {
        Vector3f up;
        float spinAngle = ((float)this.age + delta) * this.spinSpeed;
        Vector3f velocity = new Vector3f((Vector3fc)this.options.velocity()).normalize();
        if (Math.abs(velocity.dot((Vector3fc)(up = new Vector3f(0.0f, 1.0f, 0.0f)))) > 0.99f) {
            up.set(1.0f, 0.0f, 0.0f);
        }
        Quaternionf rotation = new Quaternionf().rotationTo((Vector3fc)new Vector3f(0.0f, 0.0f, 1.0f), (Vector3fc)velocity);
        rotation.rotateZ(spinAngle);
        this.renderRotatedQuad(consumer, camera, rotation, delta);
        this.renderRotatedQuad(consumer, camera, new Quaternionf((Quaternionfc)rotation).rotateY((float)Math.PI), delta);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    protected int getLightColor(float tint) {
        return Math.max(50, super.getLightColor(tint));
    }

    public static class Provider
    implements ParticleProvider<DashJumpShockwaveParticleOptions> {
        private final SpriteSet sprites;

        public Provider(SpriteSet sprites) {
            this.sprites = sprites;
        }

        @Nullable
        public Particle createParticle(DashJumpShockwaveParticleOptions options, ClientLevel level, double x, double y, double z, double xd, double yd, double zd) {
            return new DashJumpShockwaveParticle(level, x, y, z, this.sprites, options);
        }
    }
}

