/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.client.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SimpleAnimatedParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.SimpleParticleType;

public class DashJumpSparksParticle
extends SimpleAnimatedParticle {
    DashJumpSparksParticle(ClientLevel level, double x, double y, double z, double xd, double yd, double zd, SpriteSet sprites) {
        super(level, x, y, z, sprites, 0.1f);
        this.xd = xd;
        this.yd = yd;
        this.zd = zd;
        this.quadSize = 0.02f;
        this.lifetime = 48 + this.random.nextInt(12);
        this.setSpriteFromAge(sprites);
    }

    public void tick() {
        if (this.age >= this.lifetime / 2) {
            this.quadSize *= 0.95f;
        }
        if (this.quadSize < 0.005f) {
            this.remove();
        }
        super.tick();
    }

    public void render(VertexConsumer vertexConsumer, Camera camera, float f) {
        if (this.age < this.lifetime / 3 || (this.age + this.lifetime) / 3 % 2 == 0) {
            super.render(vertexConsumer, camera, f);
        }
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Provider(SpriteSet sprites) {
            this.sprites = sprites;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double d, double xd, double yd, double zd) {
            return new DashJumpSparksParticle(level, x, y, d, xd, yd, zd, this.sprites);
        }
    }
}

