/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SimpleAnimatedParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.level.BlockAndTintGetter;

public class EnderPearlParticle
extends SimpleAnimatedParticle {
    EnderPearlParticle(ClientLevel level, double x, double y, double z, double xd, double yd, double zd, SpriteSet sprites) {
        super(level, x, y, z, sprites, 0.1f);
        float color = this.random.nextFloat() * 0.6f + 0.4f;
        this.rCol = color * 0.9f;
        this.gCol = color * 0.3f;
        this.bCol = color;
        this.xd = xd;
        this.yd = yd;
        this.zd = zd;
        this.quadSize = 0.1f;
        this.lifetime = 25 + this.random.nextInt(15);
        this.setSpriteFromAge(sprites);
    }

    public void tick() {
        if (this.age >= this.lifetime / 2) {
            this.quadSize *= 0.95f;
        }
        if (this.quadSize < 0.005f) {
            this.remove();
        }
        super.tick();
    }

    public int getLightColor(float delta) {
        BlockPos pos = BlockPos.containing((double)this.x, (double)this.y, (double)this.z);
        int color = this.level.hasChunkAt(pos) ? LevelRenderer.getLightColor((BlockAndTintGetter)this.level, (BlockPos)pos) : 0;
        return Math.max(160, color);
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Provider(SpriteSet sprites) {
            this.sprites = sprites;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xd, double yd, double zd) {
            return new EnderPearlParticle(level, x, y, z, xd, yd, zd, this.sprites);
        }
    }
}

