/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SimpleAnimatedParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;

public class NebuliteOreParticle
extends SimpleAnimatedParticle {
    NebuliteOreParticle(ClientLevel level, double x, double y, double z, double xd, double yd, double zd, SpriteSet sprites) {
        super(level, x, y, z, sprites, 0.0f);
        this.setSpriteFromAge(sprites);
        this.gravity = 0.02f;
        this.friction = 0.9f;
        this.quadSize = Mth.nextFloat((RandomSource)this.random, (float)0.06f, (float)0.12f);
        this.lifetime = Mth.nextInt((RandomSource)this.random, (int)30, (int)60);
        this.setColor(0.55f, 0.2f, 0.7f);
        this.alpha = Mth.nextFloat((RandomSource)this.random, (float)0.75f, (float)1.0f);
        this.hasPhysics = false;
        this.xd = xd;
        this.yd = yd;
        this.zd = zd;
    }

    public void tick() {
        super.tick();
        if (!this.removed) {
            this.setSpriteFromAge(this.sprites);
            if (this.age > this.lifetime / 2) {
                this.setAlpha(1.0f - (float)(this.age - this.lifetime / 2) / (float)this.lifetime);
            }
            this.rCol += Mth.sin((float)((float)this.age * 0.12f)) * 0.02f;
        }
    }

    public int getLightColor(float tint) {
        int color = 0;
        BlockPos pos = BlockPos.containing((double)this.x, (double)this.y, (double)this.z);
        if (this.level.getChunk(pos) != null) {
            color = LevelRenderer.getLightColor((BlockAndTintGetter)this.level, (BlockPos)pos);
        }
        return Math.max(150, color);
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Provider(SpriteSet sprites) {
            this.sprites = sprites;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xd, double yd, double zd) {
            return new NebuliteOreParticle(level, x, y, z, xd, yd, zd, this.sprites);
        }
    }
}

