/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.client.particle;

import net.bunten.enderscape.registry.EnderscapeEntitySounds;
import net.bunten.enderscape.registry.EnderscapeParticles;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;

public class RustleSleepingBubbleParticle
extends TextureSheetParticle {
    public RustleSleepingBubbleParticle(ClientLevel level, double x, double y, double z, double xd, double yd, double zd, SpriteSet sprites) {
        super(level, x, y, z);
        this.setSize(0.02f, 0.02f);
        this.setSpriteFromAge(sprites);
        this.quadSize *= this.random.nextFloat() * 0.6f + 0.2f;
        this.lifetime = 60;
        this.xd = xd * (double)0.2f + (Math.random() * 2.0 - 1.0) * (double)0.02f;
        this.yd = yd * (double)0.2f + (Math.random() * 2.0 - 1.0) * (double)0.02f;
        this.zd = zd * (double)0.2f + (Math.random() * 2.0 - 1.0) * (double)0.02f;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        } else {
            this.yd += 0.002;
            this.move(this.xd, this.yd, this.zd);
            this.xd *= (double)0.85f;
            this.yd *= (double)0.85f;
            this.zd *= (double)0.85f;
        }
    }

    public void remove() {
        super.remove();
        this.pop();
    }

    private void pop() {
        this.level.addParticle((ParticleOptions)EnderscapeParticles.RUSTLE_SLEEPING_BUBBLE_POP.get(), this.x, this.y, this.z, 0.0, 0.0, 0.0);
        this.level.playLocalSound(this.x, this.y, this.z, EnderscapeEntitySounds.RUSTLE_SLEEPING_BUBBLE_POP.get(), SoundSource.AMBIENT, 1.0f, Mth.nextFloat((RandomSource)this.random, (float)0.9f, (float)1.1f), false);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Provider(SpriteSet sprites) {
            this.sprites = sprites;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xd, double yd, double zd) {
            return new RustleSleepingBubbleParticle(level, x, y, z, xd, yd, zd, this.sprites);
        }
    }
}

