/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;

public class VeiledLeavesParticle
extends TextureSheetParticle {
    private float rotSpeed;
    private final float spinAcceleration;
    private final float windBig;
    private final boolean swirl;
    private final boolean flowAway;
    private final double xaFlowScale;
    private final double zaFlowScale;
    private final double swirlPeriod;

    protected VeiledLeavesParticle(ClientLevel level, double x, double y, double z, SpriteSet sprites, float gravity, float windBig, boolean swirl, boolean flowAway, float i) {
        super(level, x, y, z);
        float size;
        this.setSprite(sprites.get(this.random.nextInt(12), 12));
        this.flowAway = flowAway;
        this.gravity = gravity * 1.2f * 0.0025f;
        this.swirl = swirl;
        this.windBig = windBig;
        this.friction = 1.0f;
        this.lifetime = 300;
        this.rotSpeed = (float)Math.toRadians(this.random.nextBoolean() ? -30.0 : 30.0);
        this.spinAcceleration = (float)Math.toRadians(this.random.nextBoolean() ? -5.0 : 5.0);
        float particleRandom = this.random.nextFloat();
        this.swirlPeriod = Math.toRadians(1000.0f + particleRandom * 3000.0f);
        this.xaFlowScale = Math.cos(Math.toRadians(particleRandom * 60.0f)) * (double)this.windBig;
        this.zaFlowScale = Math.sin(Math.toRadians(particleRandom * 60.0f)) * (double)this.windBig;
        this.quadSize = size = i * (this.random.nextBoolean() ? 0.05f : 0.075f);
        this.setSize(size, size);
        this.xd = 0.05;
        this.yd = this.random.nextGaussian() * 0.025 + 0.03;
        this.zd = 0.05;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.lifetime-- <= 0) {
            this.remove();
        }
        if (!this.removed) {
            float f = 300 - this.lifetime;
            float g = Math.min(f / 300.0f, 1.0f);
            double d = 0.0;
            double e = 0.0;
            if (this.flowAway) {
                d += this.xaFlowScale * Math.pow(g, 1.25);
                e += this.zaFlowScale * Math.pow(g, 1.25);
            }
            if (this.swirl) {
                d += (double)g * Math.cos((double)g * this.swirlPeriod) * (double)this.windBig;
                e += (double)g * Math.sin((double)g * this.swirlPeriod) * (double)this.windBig;
            }
            this.xd += d * (double)0.0025f;
            this.zd += e * (double)0.0025f;
            this.yd -= (double)this.gravity;
            this.rotSpeed += this.spinAcceleration / 20.0f;
            this.oRoll = this.roll;
            this.roll += this.rotSpeed / 20.0f;
            this.move(this.xd, this.yd, this.zd);
            if (this.onGround || this.lifetime < 299 && (this.xd == 0.0 || this.zd == 0.0)) {
                this.remove();
            }
            if (!this.removed) {
                this.xd *= (double)this.friction;
                this.yd *= (double)this.friction;
                this.zd *= (double)this.friction;
            }
        }
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Provider(SpriteSet sprites) {
            this.sprites = sprites;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xd, double yd, double zd) {
            return new VeiledLeavesParticle(level, x, y, z, this.sprites, 0.25f, 2.0f, false, true, 1.0f);
        }
    }
}

