/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.client.registry;

import java.util.Optional;
import net.bunten.enderscape.Enderscape;
import net.bunten.enderscape.EnderscapeConfig;
import net.bunten.enderscape.client.EnderscapeClient;
import net.bunten.enderscape.client.entity.EndermanStareSoundInstance;
import net.bunten.enderscape.client.entity.EndermanStaticSoundInstance;
import net.bunten.enderscape.network.ClientboundDashJumpPayload;
import net.bunten.enderscape.network.ClientboundDashJumpSoundPayload;
import net.bunten.enderscape.network.ClientboundMirrorTeleportInfoPayload;
import net.bunten.enderscape.network.ClientboundNebuliteOreSoundPayload;
import net.bunten.enderscape.network.ClientboundRubbleShieldCooldownSoundPayload;
import net.bunten.enderscape.network.ClientboundStareOverlayPayload;
import net.bunten.enderscape.network.ClientboundStareSoundPayload;
import net.bunten.enderscape.network.ClientboundStructureChangedPayload;
import net.bunten.enderscape.network.ClientboundTransdimensionalTravelSoundPayload;
import net.bunten.enderscape.registry.EnderscapeBlockSounds;
import net.bunten.enderscape.registry.EnderscapeItemSounds;
import net.bunten.enderscape.registry.EnderscapeMusic;
import net.bunten.enderscape.util.BlockUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class EnderscapeClientNetworking {
    public static void receiveDashJumpPayload(ClientboundDashJumpPayload payload, IPayloadContext context) {
        Minecraft client = Minecraft.getInstance();
        LocalPlayer player = client.player;
        client.execute(() -> {
            if (player == null || !player.isAlive() || player.isSpectator()) {
                return;
            }
            Vec3 travel = new Vec3((double)player.xxa, (double)player.yya, (double)player.zza).normalize();
            float sinYRot = Mth.sin((float)(player.getYRot() * ((float)Math.PI / 180)));
            float cosYRot = Mth.cos((float)(player.getYRot() * ((float)Math.PI / 180)));
            float hozPower = player.isFallFlying() ? payload.horizontalPower() * payload.glideVelocityFactor() : payload.horizontalPower();
            float verPower = player.isFallFlying() ? payload.verticalPower() * payload.glideVelocityFactor() : payload.verticalPower();
            player.setDeltaMovement(new Vec3(travel.x * (double)hozPower * (double)cosYRot - travel.z * (double)hozPower * (double)sinYRot, (double)verPower, travel.z * (double)hozPower * (double)cosYRot + travel.x * (double)hozPower * (double)sinYRot));
        });
    }

    public static void receiveDashJumpSoundPayload(ClientboundDashJumpSoundPayload payload, IPayloadContext context) {
        Minecraft client = Minecraft.getInstance();
        client.execute(() -> {
            Entity entity = client.level.getEntity(payload.entityId());
            if (entity != null && entity.isAlive() && !entity.isSpectator()) {
                SoundEvent soundEvent = (SoundEvent)client.level.registryAccess().lookupOrThrow(Registries.SOUND_EVENT).getOrThrow(ResourceKey.create((ResourceKey)Registries.SOUND_EVENT, (ResourceLocation)payload.soundEvent())).value();
                client.level.playLocalSound(entity, soundEvent, entity.getSoundSource(), 1.0f, 1.0f);
            }
        });
    }

    public static void receiveMirrorTeleportPayload(ClientboundMirrorTeleportInfoPayload payload, IPayloadContext context) {
        Minecraft client = Minecraft.getInstance();
        client.execute(() -> {
            EnderscapeClient.postMirrorUseTicks = 60;
        });
    }

    public static void receiveNebuliteOreSoundPayload(ClientboundNebuliteOreSoundPayload payload, IPayloadContext context) {
        Minecraft client = Minecraft.getInstance();
        client.execute(() -> {
            BlockPos nebulite = payload.globalPos().pos();
            ResourceKey dimension = payload.globalPos().dimension();
            ClientLevel level = client.level;
            Entity entity = client.cameraEntity;
            if (level != null && level.dimension() == dimension && entity instanceof LivingEntity) {
                LivingEntity mob = (LivingEntity)entity;
                SoundEvent sound = BlockUtil.isBlockObstructed((Level)level, nebulite) ? EnderscapeBlockSounds.NEBULITE_ORE_IDLE_OBSTRUCTED : (mob.blockPosition().closerThan((Vec3i)nebulite, 12.0) ? EnderscapeBlockSounds.NEBULITE_ORE_IDLE : EnderscapeBlockSounds.NEBULITE_ORE_IDLE_FAR);
                float range = Mth.clamp((float)((float)((double)nebulite.getY() - mob.getY())), (float)-8.0f, (float)0.0f) / 20.0f + Mth.nextFloat((RandomSource)level.getRandom(), (float)0.9f, (float)1.1f);
                level.playLocalSound((double)nebulite.getX(), (double)nebulite.getY(), (double)nebulite.getZ(), sound, SoundSource.BLOCKS, range, range, false);
            }
        });
    }

    public static void receiveRubbleShieldCooldownSoundPayload(ClientboundRubbleShieldCooldownSoundPayload payload, IPayloadContext context) {
        Minecraft client = Minecraft.getInstance();
        client.execute(() -> {
            if (client.player != null) {
                client.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI(EnderscapeItemSounds.RUBBLE_SHIELD_COOLDOWN_OVER, (float)1.0f));
            }
        });
    }

    public static void receiveStareOverlayPayload(ClientboundStareOverlayPayload payload, IPayloadContext context) {
        Minecraft client = Minecraft.getInstance();
        client.execute(() -> {
            if (EnderscapeClient.stareTicks < 100) {
                EnderscapeClient.stareTicks += 2;
            }
            if ((EnderscapeClient.staticSoundInstance == null || !client.getSoundManager().isActive((SoundInstance)EnderscapeClient.staticSoundInstance)) && EnderscapeConfig.getInstance().endermanStaticSound) {
                EnderscapeClient.staticSoundInstance = new EndermanStaticSoundInstance(client);
                client.getSoundManager().play((SoundInstance)EnderscapeClient.staticSoundInstance);
            }
        });
    }

    public static void receiveStareSoundPayload(ClientboundStareSoundPayload payload, IPayloadContext context) {
        Minecraft client = Minecraft.getInstance();
        int entityId = payload.entityId();
        client.execute(() -> client.getSoundManager().play((SoundInstance)new EndermanStareSoundInstance(client, entityId)));
    }

    public static void receiveStructureChangedPayload(ClientboundStructureChangedPayload payload, IPayloadContext context) {
        Minecraft client = Minecraft.getInstance();
        ResourceLocation location = payload.location();
        client.execute(() -> {
            EnderscapeClient.structureMusic = location.equals((Object)Enderscape.END_CITY_RESOURCE_KEY.location()) ? Optional.of(EnderscapeMusic.MUSIC_END_CITY) : Optional.empty();
        });
    }

    public static void receiveTransdimensionalTravelSoundPayload(ClientboundTransdimensionalTravelSoundPayload payload, IPayloadContext context) {
        Minecraft client = Minecraft.getInstance();
        client.execute(() -> client.getSoundManager().play((SoundInstance)SimpleSoundInstance.forLocalAmbience((SoundEvent)EnderscapeItemSounds.MIRROR_TRANSDIMENSIONAL_TRAVEL.get(), (float)1.0f, (float)0.4f)));
    }
}

