/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.client.world;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import net.bunten.enderscape.Enderscape;
import net.bunten.enderscape.EnderscapeConfig;
import net.minecraft.client.Camera;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.CubicSampler;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class EnderscapeSkybox {
    public static final Axis SKY_ROTATION_AXIS = Axis.YP;
    public static float fogStartDensity = 1.0f;
    public static float fogEndDensity = 1.0f;
    public static Vector4f nebulaColor = new Vector4f(0.0f, 0.0f, 0.0f, 0.0f);
    public static Vector4f starColor = new Vector4f(0.0f, 0.0f, 0.0f, 0.0f);
    private static final VertexBuffer nebula1 = EnderscapeSkybox.createNebulaeBuffer(16.0, 64.0, 60, 2L);
    private static final VertexBuffer nebula2 = EnderscapeSkybox.createNebulaeBuffer(16.0, 64.0, 60, 3L);
    private static final VertexBuffer stars = EnderscapeSkybox.createStarsBuffer();

    public static float gammaFactor() {
        if (!EnderscapeConfig.getInstance().skyboxScalesBrightnessWithGamma) {
            return 1.0f;
        }
        float gamma = ((Double)Minecraft.getInstance().options.gamma().get()).floatValue();
        float scale = (float)EnderscapeConfig.getInstance().skyboxBrightnessScaleFactor / 100.0f;
        return 1.0f + gamma * scale;
    }

    private static Vector4f computeSkyColor(Camera camera, ClientLevel level) {
        Vec3 position = camera.getPosition().subtract(2.0, 2.0, 2.0).scale(0.25);
        Vec3 skyColor = CubicSampler.gaussianSampleVec3((Vec3)position, (ix, jx, k) -> Vec3.fromRGB24((int)((Biome)level.getBiomeManager().getNoiseBiomeAtQuart(ix, jx, k).value()).getSkyColor())).scale((double)EnderscapeSkybox.gammaFactor());
        return new Vector4f((float)skyColor.x(), (float)skyColor.y(), (float)skyColor.z(), 1.0f);
    }

    public static void render(PoseStack pose, ClientLevel level, Camera camera, DeltaTracker tracker) {
        float gameTime = ((float)level.getGameTime() + tracker.getGameTimeDeltaTicks()) % 360000.0f;
        float baseSpeed = gameTime * 3.0E-5f;
        EnderscapeSkybox.renderSkybox(pose, EnderscapeSkybox.computeSkyColor(camera, level), baseSpeed);
        EnderscapeSkybox.renderNebulae(pose, nebulaColor, baseSpeed * 5.0f);
        EnderscapeSkybox.renderStars(pose, starColor, baseSpeed * 10.0f);
    }

    private static void renderSkybox(PoseStack pose, Vector4f color, float angle) {
        Matrix4fStack matrix = RenderSystem.getModelViewStack();
        matrix.pushMatrix();
        matrix.mul((Matrix4fc)pose.last().pose());
        matrix.mul((Matrix4fc)new Matrix4f().rotation((Quaternionfc)SKY_ROTATION_AXIS.rotation(angle)));
        RenderSystem.enableBlend();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        RenderSystem.setShaderColor((float)color.x, (float)color.y, (float)color.z, (float)color.w);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)Enderscape.id("textures/environment/sky.png"));
        Tesselator tesselator = Tesselator.getInstance();
        for (int i = 0; i < 6; ++i) {
            pose.pushPose();
            switch (i) {
                case 1: {
                    pose.mulPose(Axis.XP.rotationDegrees(90.0f));
                    break;
                }
                case 2: {
                    pose.mulPose(Axis.XP.rotationDegrees(-90.0f));
                    break;
                }
                case 3: {
                    pose.mulPose(Axis.XP.rotationDegrees(180.0f));
                    break;
                }
                case 4: {
                    pose.mulPose(Axis.ZP.rotationDegrees(90.0f));
                    break;
                }
                case 5: {
                    pose.mulPose(Axis.ZP.rotationDegrees(-90.0f));
                }
            }
            Matrix4f matrix4f = pose.last().pose();
            BufferBuilder builder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
            builder.addVertex(matrix4f, -100.0f, -100.0f, -100.0f).setUv(0.0f, 0.0f).setColor(-1);
            builder.addVertex(matrix4f, -100.0f, -100.0f, 100.0f).setUv(0.0f, 16.0f).setColor(-1);
            builder.addVertex(matrix4f, 100.0f, -100.0f, 100.0f).setUv(16.0f, 16.0f).setColor(-1);
            builder.addVertex(matrix4f, 100.0f, -100.0f, -100.0f).setUv(16.0f, 0.0f).setColor(-1);
            BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
            pose.popPose();
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
        matrix.popMatrix();
    }

    private static VertexBuffer createNebulaeBuffer(double minSize, double maxSize, int count, long seed) {
        VertexBuffer buffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
        buffer.bind();
        buffer.upload(EnderscapeSkybox.drawNebulae(minSize, maxSize, count, seed, Tesselator.getInstance()));
        VertexBuffer.unbind();
        return buffer;
    }

    private static MeshData drawNebulae(double minSize, double maxSize, int count, long seed, Tesselator tesselator) {
        LegacyRandomSource random = new LegacyRandomSource(seed);
        BufferBuilder builder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        for (int i = 0; i < count; ++i) {
            double posX = random.nextDouble() * 2.0 - 1.0;
            double posY = random.nextDouble() - 0.5;
            double posZ = random.nextDouble() * 2.0 - 1.0;
            double size = Mth.nextDouble((RandomSource)random, (double)minSize, (double)maxSize);
            double length = posX * posX + posY * posY + posZ * posZ;
            double distance = 2.0;
            if (!(length < 1.0) || !(length > 0.001)) continue;
            length = distance / Math.sqrt(length);
            size *= distance;
            double px = (posX *= length) * 100.0;
            double py = (posY *= length) * 100.0;
            double pz = (posZ *= length) * 100.0;
            double angle = Math.atan2(posX, posZ);
            double sin1 = Math.sin(angle);
            double cos1 = Math.cos(angle);
            angle = Math.atan2(Math.sqrt(posX * posX + posZ * posZ), posY);
            double sin2 = Math.sin(angle);
            double cos2 = Math.cos(angle);
            angle = random.nextDouble() * Math.PI * 2.0;
            double sin3 = Math.sin(angle);
            double cos3 = Math.cos(angle);
            for (int index = 0; index < 4; ++index) {
                double x = (double)((index & 2) - 1) * size;
                double y = (double)((index + 1 & 2) - 1) * size;
                double aa = x * cos3 - y * sin3;
                double ab = y * cos3 + x * sin3;
                double dy = aa * sin2 + 0.0 * cos2;
                double ae = 0.0 * sin2 - aa * cos2;
                double dx = ae * sin1 - ab * cos1;
                double dz = ab * sin1 + ae * cos1;
                float texU = index >> 1 & 1;
                float texV = index + 1 >> 1 & 1;
                builder.addVertex((float)(px + dx), (float)(py + dy), (float)(pz + dz)).setUv(texU, texV);
            }
        }
        return builder.buildOrThrow();
    }

    private static void renderNebulae(PoseStack pose, Vector4f color, float angle) {
        Matrix4fStack matrix = RenderSystem.getModelViewStack();
        matrix.pushMatrix();
        matrix.mul((Matrix4fc)pose.last().pose());
        matrix.mul((Matrix4fc)new Matrix4f().rotation((Quaternionfc)SKY_ROTATION_AXIS.rotation(angle)));
        RenderSystem.depthMask((boolean)false);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)color.x, (float)color.y, (float)color.z, (float)color.w);
        RenderSystem.enableBlend();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)Enderscape.id("textures/environment/nebula1.png"));
        nebula1.bind();
        nebula1.drawWithShader((Matrix4f)matrix, RenderSystem.getProjectionMatrix(), RenderSystem.getShader());
        VertexBuffer.unbind();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)Enderscape.id("textures/environment/nebula2.png"));
        nebula2.bind();
        nebula2.drawWithShader((Matrix4f)matrix, RenderSystem.getProjectionMatrix(), RenderSystem.getShader());
        VertexBuffer.unbind();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.depthMask((boolean)true);
        matrix.popMatrix();
    }

    private static VertexBuffer createStarsBuffer() {
        VertexBuffer buffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
        buffer.bind();
        buffer.upload(EnderscapeSkybox.drawStars(1500, 0.05f, 0.25f, Tesselator.getInstance()));
        VertexBuffer.unbind();
        return buffer;
    }

    private static MeshData drawStars(int count, float minSize, float maxSize, Tesselator tesselator) {
        RandomSource random = RandomSource.create((long)10842L);
        float scale = 100.0f;
        BufferBuilder builder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION);
        for (int i = 0; i < count; ++i) {
            float z;
            float y;
            float size = Mth.randomBetween((RandomSource)random, (float)minSize, (float)maxSize);
            float x = random.nextFloat() * 2.0f - 1.0f;
            float lengthSquared = Mth.lengthSquared((float)x, (float)(y = random.nextFloat() * 2.0f - 1.0f), (float)(z = random.nextFloat() * 2.0f - 1.0f));
            if (lengthSquared <= 0.010000001f || lengthSquared >= 1.0f) continue;
            Vector3f direction = new Vector3f(x, y, z).normalize(scale);
            float rotation = (float)(random.nextDouble() * 3.1415927410125732 * 2.0);
            Matrix3f matrix = new Matrix3f().rotateTowards((Vector3fc)new Vector3f((Vector3fc)direction).negate(), (Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f)).rotateZ(-rotation);
            builder.addVertex(new Vector3f(size, -size, 0.0f).mul((Matrix3fc)matrix).add((Vector3fc)direction));
            builder.addVertex(new Vector3f(size, size, 0.0f).mul((Matrix3fc)matrix).add((Vector3fc)direction));
            builder.addVertex(new Vector3f(-size, size, 0.0f).mul((Matrix3fc)matrix).add((Vector3fc)direction));
            builder.addVertex(new Vector3f(-size, -size, 0.0f).mul((Matrix3fc)matrix).add((Vector3fc)direction));
        }
        return builder.buildOrThrow();
    }

    private static void renderStars(PoseStack pose, Vector4f color, float angle) {
        Matrix4fStack matrix = RenderSystem.getModelViewStack();
        matrix.pushMatrix();
        matrix.mul((Matrix4fc)pose.last().pose());
        matrix.mul((Matrix4fc)new Matrix4f().rotation((Quaternionfc)SKY_ROTATION_AXIS.rotation(angle)));
        RenderSystem.depthMask((boolean)false);
        RenderSystem.setShader(GameRenderer::getPositionShader);
        RenderSystem.setShaderColor((float)color.x, (float)color.y, (float)color.z, (float)color.w);
        RenderSystem.enableBlend();
        stars.bind();
        stars.drawWithShader((Matrix4f)matrix, RenderSystem.getProjectionMatrix(), RenderSystem.getShader());
        VertexBuffer.unbind();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.depthMask((boolean)true);
        matrix.popMatrix();
    }
}

