/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.criteria;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.bunten.enderscape.entity.drifter.Drifter;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.LootContext;

public class BounceOnDrifterCriterion
extends SimpleCriterionTrigger<Conditions> {
    public void trigger(ServerPlayer player, Drifter drifter) {
        this.trigger(player, instance -> instance.matches(EntityPredicate.createContext((ServerPlayer)player, (Entity)drifter)));
    }

    public Codec<Conditions> codec() {
        return Conditions.CODEC;
    }

    public record Conditions(Optional<ContextAwarePredicate> player, Optional<ContextAwarePredicate> drifter) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<Conditions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(Conditions::player), (App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("drifter").forGetter(Conditions::drifter)).apply((Applicative)instance, Conditions::new));

        public boolean matches(LootContext context) {
            return this.drifter.isEmpty() || this.drifter.get().matches(context);
        }
    }
}

