/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.criteria;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DistancePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public class MirrorTeleportCriterion
extends SimpleCriterionTrigger<Conditions> {
    public void trigger(ServerPlayer player, ItemStack stack, GlobalPos prior, GlobalPos latter) {
        this.trigger(player, instance -> instance.matches(player.getServer(), stack, prior, latter));
    }

    public Codec<Conditions> codec() {
        return Conditions.CODEC;
    }

    public record Conditions(Optional<ContextAwarePredicate> player, Optional<ItemPredicate> item, Optional<LocationPredicate> prior, Optional<LocationPredicate> latter, Optional<DistancePredicate> distance, Optional<Boolean> differentDimensions) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<Conditions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(Conditions::player), (App)ItemPredicate.CODEC.optionalFieldOf("item").forGetter(Conditions::item), (App)LocationPredicate.CODEC.optionalFieldOf("prior").forGetter(Conditions::prior), (App)LocationPredicate.CODEC.optionalFieldOf("latter").forGetter(Conditions::latter), (App)DistancePredicate.CODEC.optionalFieldOf("distance").forGetter(Conditions::distance), (App)Codec.BOOL.optionalFieldOf("different_dimensions").forGetter(Conditions::differentDimensions)).apply((Applicative)instance, Conditions::new));

        public boolean matches(MinecraftServer server, ItemStack stack, GlobalPos startGlobalPos, GlobalPos endGlobalPos) {
            BlockPos start = startGlobalPos.pos();
            BlockPos end = endGlobalPos.pos();
            if (this.item.isPresent() && !this.item.get().test(stack)) {
                return false;
            }
            if (this.prior.isPresent() && !this.prior.get().matches(server.getLevel(startGlobalPos.dimension()), (double)start.getX(), (double)start.getY(), (double)start.getZ())) {
                return false;
            }
            if (this.latter.isPresent() && !this.latter.get().matches(server.getLevel(endGlobalPos.dimension()), (double)end.getX(), (double)end.getY(), (double)end.getZ())) {
                return false;
            }
            if (this.differentDimensions().isPresent()) {
                if (this.differentDimensions().get().booleanValue()) {
                    if (this.distance.isPresent()) {
                        throw new IllegalStateException("Distance predicate rendered invalid by n\"different_dimensionsn\" being n\"truen\"");
                    }
                    return startGlobalPos.dimension() != endGlobalPos.dimension();
                }
                if (startGlobalPos.dimension() != endGlobalPos.dimension()) {
                    return false;
                }
                if (this.distance().isPresent()) {
                    return this.distance.get().matches((double)start.getX(), (double)start.getY(), (double)start.getZ(), (double)end.getX(), (double)end.getY(), (double)end.getZ());
                }
            }
            return true;
        }
    }
}

