/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.criteria;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DistancePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public class PullEntityCriterion
extends SimpleCriterionTrigger<Conditions> {
    public void trigger(ServerPlayer player, Entity entity) {
        this.trigger(player, instance -> instance.matches(player, entity));
    }

    public Codec<Conditions> codec() {
        return Conditions.CODEC;
    }

    public record Conditions(Optional<ContextAwarePredicate> player, Optional<EntityPredicate> pulledEntity, Optional<DistancePredicate> distance) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<Conditions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(Conditions::player), (App)EntityPredicate.CODEC.optionalFieldOf("pulled_entity").forGetter(Conditions::pulledEntity), (App)DistancePredicate.CODEC.optionalFieldOf("distance").forGetter(Conditions::distance)).apply((Applicative)instance, Conditions::new));

        public boolean matches(ServerPlayer player, Entity entity) {
            if (player == null || player.isRemoved()) {
                return false;
            }
            if (entity == null || entity.isRemoved()) {
                return false;
            }
            if (this.pulledEntity.isPresent() && !this.pulledEntity.get().matches(player, entity)) {
                return false;
            }
            if (this.distance.isPresent()) {
                return this.distance.get().matches(player.getX(), player.getY(), player.getZ(), entity.getX(), entity.getY(), entity.getZ());
            }
            return true;
        }
    }
}

