/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.datagen;

import java.util.List;
import java.util.Optional;
import net.bunten.enderscape.Enderscape;
import net.bunten.enderscape.criteria.BounceOnDrifterCriterion;
import net.bunten.enderscape.criteria.MirrorTeleportCriterion;
import net.bunten.enderscape.criteria.PullEntityCriterion;
import net.bunten.enderscape.registry.EnderscapeBiomes;
import net.bunten.enderscape.registry.EnderscapeBlocks;
import net.bunten.enderscape.registry.EnderscapeCriteria;
import net.bunten.enderscape.registry.EnderscapeDataComponents;
import net.bunten.enderscape.registry.EnderscapeEntities;
import net.bunten.enderscape.registry.EnderscapeItems;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DistancePredicate;
import net.minecraft.advancements.critereon.EntityFlagsPredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.EntityTypePredicate;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.ItemUsedOnLocationTrigger;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.MovementPredicate;
import net.minecraft.advancements.critereon.PlayerInteractTrigger;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.advancements.critereon.RecipeCraftedTrigger;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.neoforged.neoforge.common.data.AdvancementProvider;
import net.neoforged.neoforge.data.event.GatherDataEvent;

public class EnderscapeAdvancementProvider
extends AdvancementProvider {
    public static final List<ResourceKey<Biome>> EXPLORE_END_BIOMES = List.of(Biomes.THE_END, Biomes.END_HIGHLANDS, Biomes.END_MIDLANDS, Biomes.SMALL_END_ISLANDS, EnderscapeBiomes.VEILED_WOODLANDS, EnderscapeBiomes.MAGNIA_CRAGS, EnderscapeBiomes.CELESTIAL_GROVE, EnderscapeBiomes.CORRUPT_BARRENS, EnderscapeBiomes.VOID_DEPTHS, EnderscapeBiomes.VOID_SKIES, EnderscapeBiomes.VOID_SKY_ISLANDS);

    public EnderscapeAdvancementProvider(GatherDataEvent event) {
        super(event.getGenerator().getPackOutput(), event.getLookupProvider(), event.getExistingFileHelper(), List.of((provider, consumer, existingFileHelper) -> {
            HolderLookup.RegistryLookup itemRegistry = provider.lookupOrThrow(Registries.ITEM);
            HolderLookup.RegistryLookup blockRegistry = provider.lookupOrThrow(Registries.BLOCK);
            HolderLookup.RegistryLookup entityRegistry = provider.lookupOrThrow(Registries.ENTITY_TYPE);
            ResourceKey endGatewayKey = ResourceKey.create((ResourceKey)Registries.ADVANCEMENT, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"end/enter_end_gateway"));
            ResourceKey findEndCityKey = ResourceKey.create((ResourceKey)Registries.ADVANCEMENT, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"end/find_end_city"));
            ResourceKey elytraKey = ResourceKey.create((ResourceKey)Registries.ADVANCEMENT, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"end/elytra"));
            ItemStack glintMirror = EnderscapeItems.MIRROR.get().getDefaultInstance();
            glintMirror.set(DataComponents.ENCHANTMENT_GLINT_OVERRIDE, (Object)true);
            AdvancementHolder rustleBucket = Advancement.Builder.advancement().parent(endGatewayKey.location()).display((ItemLike)EnderscapeItems.RUSTLE_BUCKET.get(), (Component)Component.translatable((String)"advancement.enderscape.rustle_bucket"), (Component)Component.translatable((String)"advancement.enderscape.rustle_bucket.description"), null, AdvancementType.TASK, true, true, false).addCriterion(BuiltInRegistries.ITEM.getKey((Object)EnderscapeItems.RUSTLE_BUCKET.get()).getPath(), PlayerInteractTrigger.TriggerInstance.itemUsedOnEntity(Optional.empty(), (ItemPredicate.Builder)ItemPredicate.Builder.item().of(new ItemLike[]{Items.BUCKET}), Optional.of(EntityPredicate.wrap((EntityPredicate.Builder)EntityPredicate.Builder.entity().of((EntityType)EnderscapeEntities.RUSTLE.get()))))).save(consumer, Enderscape.id("rustle_bucket").toString());
            AdvancementHolder unlockEndVault = Advancement.Builder.advancement().parent(findEndCityKey.location()).display((ItemLike)EnderscapeItems.END_CITY_KEY.get(), (Component)Component.translatable((String)"advancement.enderscape.unlock_end_vault"), (Component)Component.translatable((String)"advancement.enderscape.unlock_end_vault.description"), null, AdvancementType.TASK, true, true, true).addCriterion("unlock_end_vault", ItemUsedOnLocationTrigger.TriggerInstance.itemUsedOnBlock((LocationPredicate.Builder)LocationPredicate.Builder.location().setBlock(BlockPredicate.Builder.block().of(new Block[]{EnderscapeBlocks.END_VAULT.get()})), (ItemPredicate.Builder)ItemPredicate.Builder.item().of(new ItemLike[]{(ItemLike)EnderscapeItems.END_CITY_KEY.get()}))).save(consumer, Enderscape.id("unlock_end_vault").toString());
            Advancement.Builder exploreEnd = Advancement.Builder.advancement().parent(endGatewayKey.location()).display((ItemLike)EnderscapeBlocks.CELESTIAL_OVERGROWTH.get(), (Component)Component.translatable((String)"advancement.enderscape.explore_end"), (Component)Component.translatable((String)"advancement.enderscape.explore_end.description"), null, AdvancementType.CHALLENGE, true, true, false).rewards(AdvancementRewards.Builder.experience((int)1000));
            EXPLORE_END_BIOMES.forEach(biome -> exploreEnd.addCriterion(biome.location().toString(), PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)provider.lookupOrThrow(Registries.BIOME).getOrThrow(biome)))));
            exploreEnd.save(consumer, Enderscape.id("explore_end").toString());
            AdvancementHolder obtainNebulite = Advancement.Builder.advancement().parent(endGatewayKey.location()).display((ItemLike)EnderscapeItems.NEBULITE.get(), (Component)Component.translatable((String)"advancement.enderscape.obtain_nebulite"), (Component)Component.translatable((String)"advancement.enderscape.obtain_nebulite.description"), null, AdvancementType.TASK, true, true, false).addCriterion("obtained", RecipeCraftedTrigger.TriggerInstance.craftedItem((ResourceLocation)Enderscape.id("nebulite_from_shards"))).save(consumer, Enderscape.id("craft_nebulite").toString());
            AdvancementHolder bottleDriftJelly = Advancement.Builder.advancement().parent(endGatewayKey.location()).display((ItemLike)EnderscapeItems.DRIFT_JELLY_BOTTLE.get(), (Component)Component.translatable((String)"advancement.enderscape.bottle_drift_jelly"), (Component)Component.translatable((String)"advancement.enderscape.bottle_drift_jelly.description"), null, AdvancementType.TASK, true, true, false).addCriterion("obtained", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)EnderscapeItems.DRIFT_JELLY_BOTTLE.get()})).save(consumer, Enderscape.id("bottle_drift_jelly").toString());
            AdvancementHolder driftLeggings = Advancement.Builder.advancement().parent(bottleDriftJelly).display((ItemLike)EnderscapeItems.DRIFT_LEGGINGS.get(), (Component)Component.translatable((String)"advancement.enderscape.drift_leggings"), (Component)Component.translatable((String)"advancement.enderscape.drift_leggings.description"), null, AdvancementType.TASK, true, true, false).addCriterion("obtained", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)EnderscapeItems.DRIFT_LEGGINGS.get()})).save(consumer, Enderscape.id("drift_leggings").toString());
            AdvancementHolder glideOntoDrifter = Advancement.Builder.advancement().parent(driftLeggings).display(Items.FIREWORK_ROCKET.getDefaultInstance(), (Component)Component.translatable((String)"advancement.enderscape.glide_onto_drifter"), (Component)Component.translatable((String)"advancement.enderscape.glide_onto_drifter.description"), null, AdvancementType.CHALLENGE, true, true, false).rewards(AdvancementRewards.Builder.experience((int)100)).addCriterion("bounced", EnderscapeCriteria.BOUNCE_ON_DRIFTER.createCriterion((CriterionTriggerInstance)new BounceOnDrifterCriterion.Conditions(Optional.of(ContextAwarePredicate.create((LootItemCondition[])new LootItemCondition[]{LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.entity().moving(MovementPredicate.speed((MinMaxBounds.Doubles)MinMaxBounds.Doubles.atLeast((double)40.0))).flags(EntityFlagsPredicate.Builder.flags().setIsFlying(Boolean.valueOf(true)))).build()})), Optional.empty()))).save(consumer, Enderscape.id("glide_onto_drifter").toString());
            AdvancementHolder mirrorTeleport = Advancement.Builder.advancement().parent(obtainNebulite).display(glintMirror, (Component)Component.translatable((String)"advancement.enderscape.mirror_teleport"), (Component)Component.translatable((String)"advancement.enderscape.mirror_teleport.description"), null, AdvancementType.TASK, true, true, false).addCriterion("teleported", EnderscapeCriteria.MIRROR_TELEPORT.createCriterion((CriterionTriggerInstance)new MirrorTeleportCriterion.Conditions(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty()))).save(consumer, Enderscape.id("mirror_teleport").toString());
            AdvancementHolder longDistance = Advancement.Builder.advancement().parent(mirrorTeleport).display(glintMirror, (Component)Component.translatable((String)"advancement.enderscape.long_distance"), (Component)Component.translatable((String)"advancement.enderscape.long_distance.description"), null, AdvancementType.CHALLENGE, true, true, false).rewards(AdvancementRewards.Builder.experience((int)50)).addCriterion("teleported", EnderscapeCriteria.MIRROR_TELEPORT.createCriterion((CriterionTriggerInstance)new MirrorTeleportCriterion.Conditions(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(DistancePredicate.horizontal((MinMaxBounds.Doubles)MinMaxBounds.Doubles.atLeast((double)2000.0))), Optional.of(false)))).save(consumer, Enderscape.id("long_distance").toString());
            Advancement.Builder.advancement().parent(longDistance).display(glintMirror, (Component)Component.translatable((String)"advancement.enderscape.transdimensional"), (Component)Component.translatable((String)"advancement.enderscape.transdimensional.description"), null, AdvancementType.CHALLENGE, true, true, false).rewards(AdvancementRewards.Builder.experience((int)100)).addCriterion("teleported", EnderscapeCriteria.MIRROR_TELEPORT.createCriterion((CriterionTriggerInstance)new MirrorTeleportCriterion.Conditions(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(true)))).save(consumer, Enderscape.id("transdimensional").toString());
            ItemStack attractor = EnderscapeItems.MAGNIA_ATTRACTOR.get().getDefaultInstance();
            attractor.set(EnderscapeDataComponents.CURRENT_NEBULITE_FUEL, (Object)1);
            AdvancementHolder pullItemWithAttractor = Advancement.Builder.advancement().parent(obtainNebulite).display(attractor, (Component)Component.translatable((String)"advancement.enderscape.pull_item_with_attractor"), (Component)Component.translatable((String)"advancement.enderscape.pull_item_with_attractor.description"), null, AdvancementType.TASK, true, true, false).addCriterion("pulled_item", EnderscapeCriteria.PULL_ENTITY.createCriterion((CriterionTriggerInstance)new PullEntityCriterion.Conditions(Optional.empty(), Optional.of(EntityPredicate.Builder.entity().entityType(EntityTypePredicate.of((EntityType)EntityType.ITEM)).build()), Optional.empty()))).save(consumer, Enderscape.id("pull_item_with_attractor").toString());
        }));
    }
}

