/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.datagen;

import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.bunten.enderscape.Enderscape;
import net.bunten.enderscape.biome.modifications.ModifyEndAmbianceModification;
import net.bunten.enderscape.registry.EnderscapeEntities;
import net.bunten.enderscape.registry.EnderscapePlacedFeatures;
import net.bunten.enderscape.registry.RegistryHelper;
import net.bunten.enderscape.registry.tag.EnderscapeBiomeTags;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.EndPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.BiomeModifiers;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import net.neoforged.neoforge.registries.holdersets.AndHolderSet;
import net.neoforged.neoforge.registries.holdersets.NotHolderSet;

public class EnderscapeBiomeModifiers {
    public static final List<ResourceKey<BiomeModifier>> BIOME_MODIFIERS = new ArrayList<ResourceKey<BiomeModifier>>();
    public static final ResourceKey<BiomeModifier> MODIFY_END_AMBIENCE = EnderscapeBiomeModifiers.registerKey("modify_end_ambience");
    public static final ResourceKey<BiomeModifier> ADD_GLOBAL_FEATURES = EnderscapeBiomeModifiers.registerKey("add_global_features");
    public static final ResourceKey<BiomeModifier> ADD_NEW_BARENS_SPAWNS = EnderscapeBiomeModifiers.registerKey("add_new_barens_spawns");
    public static final ResourceKey<BiomeModifier> ADD_NEW_BARENS_FEATURES = EnderscapeBiomeModifiers.registerKey("add_new_barens_features");
    public static final ResourceKey<BiomeModifier> ADD_ENDERSCAPE_CHORUS_SPROUTS = EnderscapeBiomeModifiers.registerKey("add_enderscape_chorus_sprouts");
    public static final ResourceKey<BiomeModifier> ADD_ENDERSCAPE_CHORUS_PLANTS = EnderscapeBiomeModifiers.registerKey("add_enderscape_chorus_plants");
    public static final ResourceKey<BiomeModifier> REMOVE_MINECRAFT_CHORUS_PLANTS = EnderscapeBiomeModifiers.registerKey("remove_minecraft_chorus_plants");
    public static final ResourceKey<BiomeModifier> ADD_ENDERSCAPE_ISLANDS = EnderscapeBiomeModifiers.registerKey("add_enderscape_islands");
    public static final ResourceKey<BiomeModifier> REMOVE_SMALL_END_ISLANDS = EnderscapeBiomeModifiers.registerKey("remove_small_end_islands");
    public static final ResourceKey<BiomeModifier> REMOVE_MINECRAFT_END_GATEWAYS = EnderscapeBiomeModifiers.registerKey("remove_minecraft_end_gateways");

    public EnderscapeBiomeModifiers() {
        RegistryHelper.checkAllReady();
    }

    private static ResourceKey<BiomeModifier> registerKey(String name) {
        ResourceKey key = ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)Enderscape.id(name));
        BIOME_MODIFIERS.add((ResourceKey<BiomeModifier>)key);
        return key;
    }

    private static <T extends BiomeModifier> Supplier<MapCodec<T>> register(String name, MapCodec<T> entry) {
        return RegistryHelper.register(NeoForgeRegistries.BIOME_MODIFIER_SERIALIZERS, Enderscape.id(name), () -> entry);
    }

    public void bootstrap(BootstrapContext<BiomeModifier> context) {
        HolderGetter biomeLookup = context.lookup(Registries.BIOME);
        HolderGetter placedFeatureLookup = context.lookup(Registries.PLACED_FEATURE);
        context.register(MODIFY_END_AMBIENCE, (Object)ModifyEndAmbianceModification.INSTANCE);
        context.register(ADD_GLOBAL_FEATURES, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)new AndHolderSet(new HolderSet[]{biomeLookup.getOrThrow(BiomeTags.IS_END), new NotHolderSet(null, (HolderSet)biomeLookup.getOrThrow(EnderscapeBiomeTags.EXCLUDED_FROM_GLOBAL_FEATURE_ADDITIONS))}), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatureLookup.getOrThrow(EnderscapePlacedFeatures.VOID_SHALE), placedFeatureLookup.getOrThrow(EnderscapePlacedFeatures.VOID_SHALE_BLOBS), placedFeatureLookup.getOrThrow(EnderscapePlacedFeatures.VERADITE), placedFeatureLookup.getOrThrow(EnderscapePlacedFeatures.MIRESTONE_BLOBS), placedFeatureLookup.getOrThrow(EnderscapePlacedFeatures.SHADOLINE_ORE), placedFeatureLookup.getOrThrow(EnderscapePlacedFeatures.SCATTERED_SHADOLINE_ORE), placedFeatureLookup.getOrThrow(EnderscapePlacedFeatures.NEBULITE_ORE), placedFeatureLookup.getOrThrow(EnderscapePlacedFeatures.CEILING_NEBULITE_ORE)}), GenerationStep.Decoration.UNDERGROUND_ORES));
        context.register(ADD_NEW_BARENS_SPAWNS, (Object)new BiomeModifiers.AddSpawnsBiomeModifier((HolderSet)biomeLookup.getOrThrow(EnderscapeBiomeTags.INCLUDES_NEW_BARRENS_CONTENT), List.of(new MobSpawnSettings.SpawnerData((EntityType)EnderscapeEntities.RUBBLEMITE.get(), 4, 2, 3))));
        context.register(ADD_NEW_BARENS_FEATURES, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomeLookup.getOrThrow(EnderscapeBiomeTags.INCLUDES_NEW_BARRENS_CONTENT), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatureLookup.getOrThrow(EnderscapePlacedFeatures.DRY_END_GROWTH), placedFeatureLookup.getOrThrow(EnderscapePlacedFeatures.MURUBLIGHT_SHELF)}), GenerationStep.Decoration.VEGETAL_DECORATION));
        context.register(ADD_ENDERSCAPE_CHORUS_SPROUTS, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)HolderSet.direct((Holder[])new Holder[]{biomeLookup.getOrThrow(Biomes.END_MIDLANDS), biomeLookup.getOrThrow(Biomes.END_HIGHLANDS)}), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatureLookup.getOrThrow(EnderscapePlacedFeatures.CHORUS_SPROUTS)}), GenerationStep.Decoration.VEGETAL_DECORATION));
        context.register(ADD_ENDERSCAPE_CHORUS_PLANTS, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)HolderSet.direct((Holder[])new Holder[]{biomeLookup.getOrThrow(Biomes.END_MIDLANDS), biomeLookup.getOrThrow(Biomes.END_HIGHLANDS)}), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatureLookup.getOrThrow(EnderscapePlacedFeatures.CHORUS_PLANTS)}), GenerationStep.Decoration.VEGETAL_DECORATION));
        context.register(REMOVE_MINECRAFT_CHORUS_PLANTS, (Object)new BiomeModifiers.RemoveFeaturesBiomeModifier((HolderSet)HolderSet.direct((Holder[])new Holder[]{biomeLookup.getOrThrow(Biomes.END_MIDLANDS), biomeLookup.getOrThrow(Biomes.END_HIGHLANDS)}), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatureLookup.getOrThrow(EndPlacements.CHORUS_PLANT)}), Arrays.stream(GenerationStep.Decoration.values()).collect(Collectors.toSet())));
        context.register(ADD_ENDERSCAPE_ISLANDS, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)HolderSet.direct((Holder[])new Holder[]{biomeLookup.getOrThrow(Biomes.SMALL_END_ISLANDS)}), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatureLookup.getOrThrow(EnderscapePlacedFeatures.SMALL_ISLANDS)}), GenerationStep.Decoration.RAW_GENERATION));
        context.register(REMOVE_SMALL_END_ISLANDS, (Object)new BiomeModifiers.RemoveFeaturesBiomeModifier((HolderSet)HolderSet.direct((Holder[])new Holder[]{biomeLookup.getOrThrow(Biomes.SMALL_END_ISLANDS)}), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatureLookup.getOrThrow(EndPlacements.END_ISLAND_DECORATED)}), Arrays.stream(GenerationStep.Decoration.values()).collect(Collectors.toSet())));
        context.register(REMOVE_MINECRAFT_END_GATEWAYS, (Object)new BiomeModifiers.RemoveFeaturesBiomeModifier((HolderSet)biomeLookup.getOrThrow(BiomeTags.IS_END), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatureLookup.getOrThrow(EndPlacements.END_GATEWAY_RETURN)}), Arrays.stream(GenerationStep.Decoration.values()).collect(Collectors.toSet())));
    }

    static {
        EnderscapeBiomeModifiers.register("modify_end_ambience", ModifyEndAmbianceModification.CODEC);
    }
}

