/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.datagen;

import java.util.Collection;
import java.util.Set;
import java.util.function.Function;
import net.bunten.enderscape.block.VeiledLeafPileBlock;
import net.bunten.enderscape.block.VoidShaleBlock;
import net.bunten.enderscape.registry.EnderscapeBlocks;
import net.bunten.enderscape.registry.EnderscapeItems;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.IntRange;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.AlternativesEntry;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LimitCount;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import org.jetbrains.annotations.NotNull;

public class EnderscapeBlockLootSubProvider
extends BlockLootSubProvider {
    protected EnderscapeBlockLootSubProvider(HolderLookup.Provider registries) {
        super(Set.of(), FeatureFlags.REGISTRY.allFlags(), registries);
    }

    protected Iterable<Block> getKnownBlocks() {
        return BuiltInRegistries.BLOCK.registryKeySet().stream().filter(k -> k.location().getNamespace().equals("enderscape")).map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.BLOCK).get(arg_0)).toList();
    }

    public void generate() {
        HolderLookup.RegistryLookup enchantment = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
        this.dropSelf(EnderscapeBlocks.DRIFT_JELLY_BLOCK.get());
        this.add(EnderscapeBlocks.VEILED_END_STONE.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)Items.END_STONE));
        this.add(EnderscapeBlocks.CELESTIAL_OVERGROWTH.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)Items.END_STONE));
        this.add(EnderscapeBlocks.CORRUPT_OVERGROWTH.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)EnderscapeBlocks.MIRESTONE.get()));
        this.dropOther(EnderscapeBlocks.CELESTIAL_PATH_BLOCK.get(), (ItemLike)Items.END_STONE);
        this.dropOther(EnderscapeBlocks.CORRUPT_PATH_BLOCK.get(), (ItemLike)Items.END_STONE);
        this.add(EnderscapeBlocks.DRY_END_GROWTH.get(), x$0 -> BlockLootSubProvider.createShearsOnlyDrop((ItemLike)x$0));
        this.dropPottedContents(EnderscapeBlocks.POTTED_DRY_END_GROWTH.get());
        this.add(EnderscapeBlocks.WISP_SPROUTS.get(), x$0 -> BlockLootSubProvider.createShearsOnlyDrop((ItemLike)x$0));
        this.add(EnderscapeBlocks.WISP_GROWTH.get(), x$0 -> BlockLootSubProvider.createShearsOnlyDrop((ItemLike)x$0));
        this.dropPottedContents(EnderscapeBlocks.POTTED_WISP_GROWTH.get());
        this.add(EnderscapeBlocks.WISP_FLOWER.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.dropSelf(EnderscapeBlocks.VEILED_SAPLING.get());
        this.dropPottedContents(EnderscapeBlocks.POTTED_VEILED_SAPLING.get());
        this.add(EnderscapeBlocks.CHORUS_SPROUTS.get(), x$0 -> BlockLootSubProvider.createShearsOnlyDrop((ItemLike)x$0));
        this.dropPottedContents(EnderscapeBlocks.POTTED_CHORUS_SPROUTS.get());
        this.add(EnderscapeBlocks.CELESTIAL_GROWTH.get(), x$0 -> BlockLootSubProvider.createShearsOnlyDrop((ItemLike)x$0));
        this.dropPottedContents(EnderscapeBlocks.POTTED_CELESTIAL_GROWTH.get());
        this.add(EnderscapeBlocks.CORRUPT_GROWTH.get(), x$0 -> BlockLootSubProvider.createShearsOnlyDrop((ItemLike)x$0));
        this.dropPottedContents(EnderscapeBlocks.POTTED_CORRUPT_GROWTH.get());
        this.dropSelf(EnderscapeBlocks.BULB_FLOWER.get());
        this.dropPottedContents(EnderscapeBlocks.POTTED_BULB_FLOWER.get());
        this.dropSelf(EnderscapeBlocks.END_LAMP.get());
        this.dropSelf(EnderscapeBlocks.BULB_LANTERN.get());
        this.dropSelf(EnderscapeBlocks.BLINKLAMP.get());
        this.add(EnderscapeBlocks.FLANGER_BERRY_FLOWER.get(), x$0 -> BlockLootSubProvider.createShearsOnlyDrop((ItemLike)x$0));
        this.add(EnderscapeBlocks.FLANGER_BERRY_VINE.get(), x$0 -> BlockLootSubProvider.createShearsOnlyDrop((ItemLike)x$0));
        this.add(EnderscapeBlocks.UNRIPE_FLANGER_BERRY_BLOCK.get(), x$0 -> BlockLootSubProvider.createShearsOnlyDrop((ItemLike)x$0));
        this.add(EnderscapeBlocks.RIPE_FLANGER_BERRY_BLOCK.get(), block -> this.createSilkTouchOrShearsDispatchTable((Block)block, (LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)((ItemLike)EnderscapeItems.FLANGER_BERRY.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount(this.getFortune())).apply((LootItemFunction.Builder)LimitCount.limitCount((IntRange)IntRange.upperBound((int)6))))));
        this.dropOther(EnderscapeBlocks.BLINKLIGHT_VINES_BODY.get(), (ItemLike)EnderscapeItems.BLINKLIGHT.get());
        this.dropOther(EnderscapeBlocks.BLINKLIGHT_VINES_HEAD.get(), (ItemLike)EnderscapeItems.BLINKLIGHT.get());
        this.dropPottedContents(EnderscapeBlocks.POTTED_BLINKLIGHT.get());
        this.dropSelf(EnderscapeBlocks.VEILED_LOG.get());
        this.dropSelf(EnderscapeBlocks.STRIPPED_VEILED_LOG.get());
        this.dropSelf(EnderscapeBlocks.VEILED_WOOD.get());
        this.dropSelf(EnderscapeBlocks.STRIPPED_VEILED_WOOD.get());
        this.add(EnderscapeBlocks.VEILED_LEAVES.get(), block -> this.createLeavesDrops((Block)block, (ItemLike)EnderscapeBlocks.VEILED_SAPLING.get()));
        this.add(EnderscapeBlocks.VEILED_LEAF_PILE.get(), this.createVeiledLeafPile());
        this.add(EnderscapeBlocks.VEILED_VINES.get(), block -> this.createSilkTouchOrShearsDispatchTable((Block)block, LootItem.lootTableItem((ItemLike)block).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)enchantment.getOrThrow(Enchantments.FORTUNE), (float[])new float[]{0.33f, 0.55f, 0.77f, 1.0f}))));
        this.dropSelf(EnderscapeBlocks.VEILED_PLANKS.get());
        this.dropSelf(EnderscapeBlocks.VEILED_STAIRS.get());
        this.dropSelf(EnderscapeBlocks.VEILED_SLAB.get());
        this.dropSelf(EnderscapeBlocks.VEILED_FENCE.get());
        this.dropSelf(EnderscapeBlocks.VEILED_FENCE_GATE.get());
        this.add(EnderscapeBlocks.VEILED_DOOR.get(), x$0 -> this.createDoorTable((Block)x$0));
        this.dropSelf(EnderscapeBlocks.VEILED_TRAPDOOR.get());
        this.dropSelf(EnderscapeBlocks.VEILED_PRESSURE_PLATE.get());
        this.dropSelf(EnderscapeBlocks.VEILED_BUTTON.get());
        this.dropOther(EnderscapeBlocks.VEILED_SIGN.get(), (ItemLike)EnderscapeItems.VEILED_SIGN_ITEM.get());
        this.dropOther(EnderscapeBlocks.VEILED_WALL_SIGN.get(), (ItemLike)EnderscapeItems.VEILED_SIGN_ITEM.get());
        this.dropOther(EnderscapeBlocks.VEILED_HANGING_SIGN.get(), (ItemLike)EnderscapeItems.VEILED_HANGING_SIGN_ITEM.get());
        this.dropOther(EnderscapeBlocks.VEILED_WALL_HANGING_SIGN.get(), (ItemLike)EnderscapeItems.VEILED_HANGING_SIGN_ITEM.get());
        this.dropSelf(EnderscapeBlocks.CELESTIAL_CHANTERELLE.get());
        this.dropPottedContents(EnderscapeBlocks.POTTED_CELESTIAL_CHANTERELLE.get());
        this.dropSelf(EnderscapeBlocks.CELESTIAL_CAP.get());
        this.dropSelf(EnderscapeBlocks.CELESTIAL_BRICKS.get());
        this.dropSelf(EnderscapeBlocks.CELESTIAL_BRICK_STAIRS.get());
        this.dropSelf(EnderscapeBlocks.CELESTIAL_BRICK_SLAB.get());
        this.dropSelf(EnderscapeBlocks.CELESTIAL_BRICK_WALL.get());
        this.dropSelf(EnderscapeBlocks.DUSK_PURPUR_BLOCK.get());
        this.dropSelf(EnderscapeBlocks.DUSK_PURPUR_PILLAR.get());
        this.dropSelf(EnderscapeBlocks.DUSK_PURPUR_STAIRS.get());
        this.dropSelf(EnderscapeBlocks.DUSK_PURPUR_SLAB.get());
        this.dropSelf(EnderscapeBlocks.DUSK_PURPUR_WALL.get());
        this.dropSelf(EnderscapeBlocks.CHISELED_DUSK_PURPUR.get());
        this.dropSelf(EnderscapeBlocks.PURPUR_TILES.get());
        this.dropSelf(EnderscapeBlocks.PURPUR_TILE_STAIRS.get());
        this.dropSelf(EnderscapeBlocks.PURPUR_TILE_SLAB.get());
        this.dropSelf(EnderscapeBlocks.CELESTIAL_STEM.get());
        this.dropSelf(EnderscapeBlocks.STRIPPED_CELESTIAL_STEM.get());
        this.dropSelf(EnderscapeBlocks.CELESTIAL_HYPHAE.get());
        this.dropSelf(EnderscapeBlocks.STRIPPED_CELESTIAL_HYPHAE.get());
        this.dropSelf(EnderscapeBlocks.CELESTIAL_PLANKS.get());
        this.dropSelf(EnderscapeBlocks.CELESTIAL_STAIRS.get());
        this.dropSelf(EnderscapeBlocks.CELESTIAL_SLAB.get());
        this.dropSelf(EnderscapeBlocks.CELESTIAL_FENCE.get());
        this.dropSelf(EnderscapeBlocks.CELESTIAL_FENCE_GATE.get());
        this.add(EnderscapeBlocks.CELESTIAL_DOOR.get(), x$0 -> this.createDoorTable((Block)x$0));
        this.dropSelf(EnderscapeBlocks.CELESTIAL_TRAPDOOR.get());
        this.dropSelf(EnderscapeBlocks.CELESTIAL_PRESSURE_PLATE.get());
        this.dropSelf(EnderscapeBlocks.CELESTIAL_BUTTON.get());
        this.dropOther(EnderscapeBlocks.CELESTIAL_SIGN.get(), (ItemLike)EnderscapeItems.CELESTIAL_SIGN_ITEM.get());
        this.dropOther(EnderscapeBlocks.CELESTIAL_WALL_SIGN.get(), (ItemLike)EnderscapeItems.CELESTIAL_SIGN_ITEM.get());
        this.dropOther(EnderscapeBlocks.CELESTIAL_HANGING_SIGN.get(), (ItemLike)EnderscapeItems.CELESTIAL_HANGING_SIGN_ITEM.get());
        this.dropOther(EnderscapeBlocks.CELESTIAL_WALL_HANGING_SIGN.get(), (ItemLike)EnderscapeItems.CELESTIAL_HANGING_SIGN_ITEM.get());
        this.dropOther(EnderscapeBlocks.MURUBLIGHT_SHELF.get(), (ItemLike)EnderscapeItems.MURUBLIGHT_SHELF_ITEM.get());
        this.dropSelf(EnderscapeBlocks.MURUBLIGHT_CHANTERELLE.get());
        this.dropPottedContents(EnderscapeBlocks.POTTED_MURUBLIGHT_CHANTERELLE.get());
        this.dropSelf(EnderscapeBlocks.MURUBLIGHT_CAP.get());
        this.dropSelf(EnderscapeBlocks.MURUBLIGHT_BRICKS.get());
        this.dropSelf(EnderscapeBlocks.MURUBLIGHT_BRICK_STAIRS.get());
        this.dropSelf(EnderscapeBlocks.MURUBLIGHT_BRICK_SLAB.get());
        this.dropSelf(EnderscapeBlocks.MURUBLIGHT_BRICK_WALL.get());
        this.dropSelf(EnderscapeBlocks.MURUBLIGHT_STEM.get());
        this.dropSelf(EnderscapeBlocks.STRIPPED_MURUBLIGHT_STEM.get());
        this.dropSelf(EnderscapeBlocks.MURUBLIGHT_HYPHAE.get());
        this.dropSelf(EnderscapeBlocks.STRIPPED_MURUBLIGHT_HYPHAE.get());
        this.dropSelf(EnderscapeBlocks.MURUBLIGHT_PLANKS.get());
        this.dropSelf(EnderscapeBlocks.MURUBLIGHT_STAIRS.get());
        this.dropSelf(EnderscapeBlocks.MURUBLIGHT_SLAB.get());
        this.dropSelf(EnderscapeBlocks.MURUBLIGHT_FENCE.get());
        this.dropSelf(EnderscapeBlocks.MURUBLIGHT_FENCE_GATE.get());
        this.add(EnderscapeBlocks.MURUBLIGHT_DOOR.get(), x$0 -> this.createDoorTable((Block)x$0));
        this.dropSelf(EnderscapeBlocks.MURUBLIGHT_TRAPDOOR.get());
        this.dropSelf(EnderscapeBlocks.MURUBLIGHT_PRESSURE_PLATE.get());
        this.dropSelf(EnderscapeBlocks.MURUBLIGHT_BUTTON.get());
        this.dropOther(EnderscapeBlocks.MURUBLIGHT_SIGN.get(), (ItemLike)EnderscapeItems.MURUBLIGHT_SIGN_ITEM.get());
        this.dropOther(EnderscapeBlocks.MURUBLIGHT_WALL_SIGN.get(), (ItemLike)EnderscapeItems.MURUBLIGHT_SIGN_ITEM.get());
        this.dropOther(EnderscapeBlocks.MURUBLIGHT_HANGING_SIGN.get(), (ItemLike)EnderscapeItems.MURUBLIGHT_HANGING_SIGN_ITEM.get());
        this.dropOther(EnderscapeBlocks.MURUBLIGHT_WALL_HANGING_SIGN.get(), (ItemLike)EnderscapeItems.MURUBLIGHT_HANGING_SIGN_ITEM.get());
        this.dropSelf(EnderscapeBlocks.ALLURING_MAGNIA.get());
        this.dropSelf(EnderscapeBlocks.ALLURING_MAGNIA_SPROUT.get());
        this.dropSelf(EnderscapeBlocks.REPULSIVE_MAGNIA.get());
        this.dropSelf(EnderscapeBlocks.REPULSIVE_MAGNIA_SPROUT.get());
        this.dropSelf(EnderscapeBlocks.ETCHED_ALLURING_MAGNIA.get());
        this.dropSelf(EnderscapeBlocks.ETCHED_REPULSIVE_MAGNIA.get());
        this.dropPottedContents(EnderscapeBlocks.POTTED_ALLURING_MAGNIA_SPROUT.get());
        this.dropPottedContents(EnderscapeBlocks.POTTED_REPULSIVE_MAGNIA_SPROUT.get());
        this.add(EnderscapeBlocks.VOID_SHALE.get(), block -> {
            LootItemBlockStatePropertyCondition.Builder isNatural = LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)EnderscapeBlocks.VOID_SHALE.get()).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)VoidShaleBlock.NATURAL, true));
            return (LootTable.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootTable.lootTable().withPool(LootPool.lootPool().when(this.entityPresent().invert()).when((LootItemCondition.Builder)isNatural).when(LootItemRandomChanceCondition.randomChance((float)0.2f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)block))).withPool(LootPool.lootPool().when(this.entityPresent().invert()).when(isNatural.invert()).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)block))).withPool(LootPool.lootPool().when(this.entityPresent()).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)block))));
        });
        Function<Block, LootTable.Builder> nebuliteOreDrops = block -> this.createSilkTouchDispatchTable((Block)block, (LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)((ItemLike)EnderscapeItems.NEBULITE_SHARDS.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addOreBonusCount((Holder)enchantment.getOrThrow(Enchantments.FORTUNE))).apply((LootItemFunction.Builder)LimitCount.limitCount((IntRange)IntRange.upperBound((int)8)))));
        this.add(EnderscapeBlocks.NEBULITE_ORE.get(), nebuliteOreDrops);
        this.add(EnderscapeBlocks.MIRESTONE_NEBULITE_ORE.get(), nebuliteOreDrops);
        this.dropSelf(EnderscapeBlocks.NEBULITE_BLOCK.get());
        Function<Block, LootTable.Builder> shadolineOreDrops = block -> this.createSilkTouchDispatchTable((Block)block, (LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)((ItemLike)EnderscapeItems.RAW_SHADOLINE.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)2.0f, (float)4.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addOreBonusCount((Holder)enchantment.getOrThrow(Enchantments.FORTUNE)))));
        this.add(EnderscapeBlocks.SHADOLINE_ORE.get(), shadolineOreDrops);
        this.add(EnderscapeBlocks.MIRESTONE_SHADOLINE_ORE.get(), shadolineOreDrops);
        this.dropSelf(EnderscapeBlocks.RAW_SHADOLINE_BLOCK.get());
        this.dropSelf(EnderscapeBlocks.SHADOLINE_BLOCK.get());
        this.dropSelf(EnderscapeBlocks.SHADOLINE_BLOCK_STAIRS.get());
        this.dropSelf(EnderscapeBlocks.SHADOLINE_BLOCK_SLAB.get());
        this.dropSelf(EnderscapeBlocks.SHADOLINE_BLOCK_WALL.get());
        this.dropSelf(EnderscapeBlocks.CUT_SHADOLINE.get());
        this.dropSelf(EnderscapeBlocks.CUT_SHADOLINE_STAIRS.get());
        this.dropSelf(EnderscapeBlocks.CUT_SHADOLINE_SLAB.get());
        this.dropSelf(EnderscapeBlocks.CUT_SHADOLINE_WALL.get());
        this.dropSelf(EnderscapeBlocks.CHISELED_SHADOLINE.get());
        this.dropSelf(EnderscapeBlocks.SHADOLINE_PILLAR.get());
        this.dropSelf(EnderscapeBlocks.END_STONE_STAIRS.get());
        this.dropSelf(EnderscapeBlocks.END_STONE_SLAB.get());
        this.dropSelf(EnderscapeBlocks.END_STONE_WALL.get());
        this.dropSelf(EnderscapeBlocks.POLISHED_END_STONE.get());
        this.dropSelf(EnderscapeBlocks.POLISHED_END_STONE_STAIRS.get());
        this.dropSelf(EnderscapeBlocks.POLISHED_END_STONE_SLAB.get());
        this.dropSelf(EnderscapeBlocks.POLISHED_END_STONE_WALL.get());
        this.dropSelf(EnderscapeBlocks.POLISHED_END_STONE_BUTTON.get());
        this.dropSelf(EnderscapeBlocks.POLISHED_END_STONE_PRESSURE_PLATE.get());
        this.dropSelf(EnderscapeBlocks.CHISELED_END_STONE.get());
        this.dropSelf(EnderscapeBlocks.CHISELED_PURPUR.get());
        this.dropSelf(EnderscapeBlocks.PURPUR_WALL.get());
        this.dropSelf(EnderscapeBlocks.MIRESTONE.get());
        this.dropSelf(EnderscapeBlocks.MIRESTONE_STAIRS.get());
        this.dropSelf(EnderscapeBlocks.MIRESTONE_SLAB.get());
        this.dropSelf(EnderscapeBlocks.MIRESTONE_WALL.get());
        this.dropSelf(EnderscapeBlocks.POLISHED_MIRESTONE.get());
        this.dropSelf(EnderscapeBlocks.POLISHED_MIRESTONE_STAIRS.get());
        this.dropSelf(EnderscapeBlocks.POLISHED_MIRESTONE_SLAB.get());
        this.dropSelf(EnderscapeBlocks.POLISHED_MIRESTONE_WALL.get());
        this.dropSelf(EnderscapeBlocks.POLISHED_MIRESTONE_BUTTON.get());
        this.dropSelf(EnderscapeBlocks.POLISHED_MIRESTONE_PRESSURE_PLATE.get());
        this.dropSelf(EnderscapeBlocks.MIRESTONE_BRICKS.get());
        this.dropSelf(EnderscapeBlocks.MIRESTONE_BRICK_STAIRS.get());
        this.dropSelf(EnderscapeBlocks.MIRESTONE_BRICK_SLAB.get());
        this.dropSelf(EnderscapeBlocks.MIRESTONE_BRICK_WALL.get());
        this.dropSelf(EnderscapeBlocks.CHISELED_MIRESTONE.get());
        this.dropSelf(EnderscapeBlocks.VERADITE.get());
        this.dropSelf(EnderscapeBlocks.VERADITE_STAIRS.get());
        this.dropSelf(EnderscapeBlocks.VERADITE_SLAB.get());
        this.dropSelf(EnderscapeBlocks.VERADITE_WALL.get());
        this.dropSelf(EnderscapeBlocks.POLISHED_VERADITE.get());
        this.dropSelf(EnderscapeBlocks.POLISHED_VERADITE_STAIRS.get());
        this.dropSelf(EnderscapeBlocks.POLISHED_VERADITE_SLAB.get());
        this.dropSelf(EnderscapeBlocks.POLISHED_VERADITE_WALL.get());
        this.dropSelf(EnderscapeBlocks.POLISHED_VERADITE_BUTTON.get());
        this.dropSelf(EnderscapeBlocks.POLISHED_VERADITE_PRESSURE_PLATE.get());
        this.dropSelf(EnderscapeBlocks.VERADITE_BRICKS.get());
        this.dropSelf(EnderscapeBlocks.VERADITE_BRICK_STAIRS.get());
        this.dropSelf(EnderscapeBlocks.VERADITE_BRICK_SLAB.get());
        this.dropSelf(EnderscapeBlocks.VERADITE_BRICK_WALL.get());
        this.dropSelf(EnderscapeBlocks.CHISELED_VERADITE.get());
        this.dropSelf(EnderscapeBlocks.KURODITE.get());
        this.dropSelf(EnderscapeBlocks.KURODITE_STAIRS.get());
        this.dropSelf(EnderscapeBlocks.KURODITE_SLAB.get());
        this.dropSelf(EnderscapeBlocks.KURODITE_WALL.get());
        this.dropSelf(EnderscapeBlocks.POLISHED_KURODITE.get());
        this.dropSelf(EnderscapeBlocks.POLISHED_KURODITE_STAIRS.get());
        this.dropSelf(EnderscapeBlocks.POLISHED_KURODITE_SLAB.get());
        this.dropSelf(EnderscapeBlocks.POLISHED_KURODITE_WALL.get());
        this.dropSelf(EnderscapeBlocks.POLISHED_KURODITE_BUTTON.get());
        this.dropSelf(EnderscapeBlocks.POLISHED_KURODITE_PRESSURE_PLATE.get());
        this.dropSelf(EnderscapeBlocks.KURODITE_BRICKS.get());
        this.dropSelf(EnderscapeBlocks.KURODITE_BRICK_STAIRS.get());
        this.dropSelf(EnderscapeBlocks.KURODITE_BRICK_SLAB.get());
        this.dropSelf(EnderscapeBlocks.KURODITE_BRICK_WALL.get());
        this.dropSelf(EnderscapeBlocks.CHISELED_KURODITE.get());
        this.add(EnderscapeBlocks.END_VAULT.get(), EnderscapeBlockLootSubProvider.noDrop());
        this.add(EnderscapeBlocks.END_TRIAL_SPAWNER.get(), EnderscapeBlockLootSubProvider.noDrop());
        this.add(EnderscapeBlocks.CHORUS_CAKE_ROLL.get(), EnderscapeBlockLootSubProvider.noDrop());
    }

    private Function<Block, LootTable.Builder> createVeiledLeafPile() {
        return block -> LootTable.lootTable().withPool(LootPool.lootPool().when(LootItemEntityPropertyCondition.entityPresent((LootContext.EntityTarget)LootContext.EntityTarget.THIS)).add((LootPoolEntryContainer.Builder)AlternativesEntry.alternatives((Collection)VeiledLeafPileBlock.LAYERS.getPossibleValues(), integer -> integer == 8 ? LootItem.lootTableItem((ItemLike)((ItemLike)EnderscapeBlocks.VEILED_LEAVES.get())) : LootItem.lootTableItem((ItemLike)((ItemLike)EnderscapeBlocks.VEILED_LEAF_PILE.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)integer.intValue()))).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)SnowLayerBlock.LAYERS, integer.intValue()))))));
    }

    public LootTable.Builder createLeavesDrops(Block leaves, ItemLike plant) {
        HolderLookup.RegistryLookup enchantment = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
        return this.createSilkTouchOrShearsDispatchTable(leaves, ((LootPoolSingletonContainer.Builder)this.applyExplosionCondition((ItemLike)leaves, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)plant))).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)enchantment.getOrThrow(Enchantments.FORTUNE), (float[])new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f}))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(HAS_SHEARS.or(this.hasSilkTouch()).invert()).add(((LootPoolSingletonContainer.Builder)this.applyExplosionDecay((ItemLike)leaves, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)Items.STICK).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))))).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)enchantment.getOrThrow(Enchantments.FORTUNE), (float[])new float[]{0.02f, 0.022222223f, 0.025f, 0.033333335f, 0.1f}))));
    }

    @NotNull
    private Holder.Reference<Enchantment> getFortune() {
        return this.registries.lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.FORTUNE);
    }

    public LootItemCondition.Builder entityPresent() {
        return LootItemEntityPropertyCondition.entityPresent((LootContext.EntityTarget)LootContext.EntityTarget.THIS);
    }
}

