/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.datagen;

import java.util.concurrent.ExecutionException;
import java.util.function.BiConsumer;
import net.bunten.enderscape.registry.EnderscapeBiomes;
import net.bunten.enderscape.registry.EnderscapeItems;
import net.bunten.enderscape.registry.EnderscapeLootTables;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.EnchantWithLevelsFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetComponentsFunction;
import net.minecraft.world.level.storage.loot.functions.SetEnchantmentsFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemDamageFunction;
import net.minecraft.world.level.storage.loot.predicates.LocationCheck;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import org.jetbrains.annotations.NotNull;

public class EnderscapeChestLootSubProvider
implements LootTableSubProvider {
    private final HolderLookup.Provider lookup;

    public EnderscapeChestLootSubProvider(HolderLookup.Provider lookup) {
        this.lookup = lookup;
    }

    public void generate(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> consumer) {
        try {
            LootItemConditionalFunction.Builder toolDamage = SetItemDamageFunction.setDamage((NumberProvider)UniformGenerator.between((float)0.65f, (float)0.8f));
            EnchantWithLevelsFunction.Builder toolEnchantments = EnchantWithLevelsFunction.enchantWithLevels((HolderLookup.Provider)this.lookup, (NumberProvider)UniformGenerator.between((float)20.0f, (float)30.0f));
            consumer.accept(EnderscapeLootTables.END_CITY_CHEST, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)3.0f, (float)5.0f)).add((LootPoolEntryContainer.Builder)this.createItem(Items.CHORUS_FRUIT, 12).apply(this.countBetween(2, 6))).add((LootPoolEntryContainer.Builder)this.addBiomeExclusiveItem(EnderscapeItems.FLANGER_BERRY.get(), EnderscapeBiomes.CELESTIAL_GROVE, 10).apply(this.countBetween(2, 4))).add((LootPoolEntryContainer.Builder)this.createItem(Items.BREAD, 8).apply(this.countBetween(2, 5))).add((LootPoolEntryContainer.Builder)this.createItem(Items.ENDER_PEARL, 8).apply(this.countBetween(1, 2))).add((LootPoolEntryContainer.Builder)this.createItem(Items.SPECTRAL_ARROW, 8).apply(this.countBetween(4, 8))).add((LootPoolEntryContainer.Builder)this.createItem(Items.HONEY_BOTTLE, 6).apply(this.countBetween(1, 3))).add((LootPoolEntryContainer.Builder)this.createItem(Items.DIAMOND, 4).apply(this.countBetween(1, 2))).add((LootPoolEntryContainer.Builder)this.createItem(Items.GOLD_INGOT, 4).apply(this.countBetween(1, 4))).add((LootPoolEntryContainer.Builder)this.createItem(Items.IRON_INGOT, 4).apply(this.countBetween(2, 8))).add((LootPoolEntryContainer.Builder)this.createItem(Items.GLASS_BOTTLE, 4).apply(this.countBetween(1, 3))).add((LootPoolEntryContainer.Builder)this.createItem(Items.GUNPOWDER, 4).apply(this.countBetween(2, 4))).add(this.createItem(Items.LODESTONE, 4)).add((LootPoolEntryContainer.Builder)this.createItem(Items.IRON_SWORD, 3).apply((LootItemFunction.Builder)toolEnchantments).apply((LootItemFunction.Builder)toolDamage)).add((LootPoolEntryContainer.Builder)this.createItem(Items.IRON_PICKAXE, 3).apply((LootItemFunction.Builder)toolEnchantments).apply((LootItemFunction.Builder)toolDamage)).add((LootPoolEntryContainer.Builder)this.createItem(Items.IRON_AXE, 3).apply((LootItemFunction.Builder)toolEnchantments).apply((LootItemFunction.Builder)toolDamage)).add((LootPoolEntryContainer.Builder)this.createItem(Items.IRON_HOE, 3).apply((LootItemFunction.Builder)toolEnchantments).apply((LootItemFunction.Builder)toolDamage)).add((LootPoolEntryContainer.Builder)this.createItem(Items.IRON_HELMET, 3).apply((LootItemFunction.Builder)toolEnchantments).apply((LootItemFunction.Builder)toolDamage)).add((LootPoolEntryContainer.Builder)this.createItem(Items.IRON_CHESTPLATE, 3).apply((LootItemFunction.Builder)toolEnchantments).apply((LootItemFunction.Builder)toolDamage)).add((LootPoolEntryContainer.Builder)this.createItem(Items.IRON_LEGGINGS, 3).apply((LootItemFunction.Builder)toolEnchantments).apply((LootItemFunction.Builder)toolDamage)).add((LootPoolEntryContainer.Builder)this.createItem(Items.IRON_BOOTS, 3).apply((LootItemFunction.Builder)toolEnchantments).apply((LootItemFunction.Builder)toolDamage)).add(this.createEnchantedItem(Items.BOW, 5, 15, 3)).add((LootPoolEntryContainer.Builder)this.createItem(Items.MAGENTA_DYE, 1).apply(this.countBetween(3, 6))).add((LootPoolEntryContainer.Builder)this.createItem(Items.BLACK_DYE, 1).apply(this.countBetween(3, 6))).add((LootPoolEntryContainer.Builder)this.createItem(Items.SPLASH_POTION, 1).apply(this.potionEffect((Holder<Potion>)Potions.STRONG_HEALING)).apply(this.countBetween(1, 2))).add((LootPoolEntryContainer.Builder)this.createItem(Items.SPLASH_POTION, 1).apply(this.potionEffect((Holder<Potion>)Potions.STRONG_HARMING)).apply(this.countBetween(1, 2))).add((LootPoolEntryContainer.Builder)this.createItem(Items.SPLASH_POTION, 1).apply(this.potionEffect((Holder<Potion>)Potions.LONG_SLOW_FALLING)).apply(this.countBetween(1, 2)))));
            consumer.accept(EnderscapeLootTables.END_CITY_SPAWNER_BASIC, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f)).add((LootPoolEntryContainer.Builder)this.createItem(Items.BREAD, 32).apply(this.countBetween(2, 8))).add((LootPoolEntryContainer.Builder)this.createItem(Items.GOLDEN_CARROT, 16).apply(this.countBetween(2, 8))).add((LootPoolEntryContainer.Builder)this.createItem(Items.GOLDEN_APPLE, 4).apply(this.countBetween(1, 3))).add((LootPoolEntryContainer.Builder)this.createItem(Items.SPLASH_POTION, 4).apply(this.potionEffect((Holder<Potion>)Potions.STRONG_HEALING))).add((LootPoolEntryContainer.Builder)this.createItem(Items.LINGERING_POTION, 4).apply(this.potionEffect((Holder<Potion>)Potions.LONG_SLOWNESS)))));
            consumer.accept(EnderscapeLootTables.END_CITY_SPAWNER_KEY, LootTable.lootTable().withPool(LootPool.lootPool().add(this.createItem(EnderscapeItems.END_CITY_KEY.get(), 2))));
            consumer.accept(EnderscapeLootTables.MIRESTONE_RUINS_CHEST, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)2.0f, (float)4.0f)).add((LootPoolEntryContainer.Builder)this.createItem(Items.BONE, 12).apply(this.countBetween(3, 6))).add((LootPoolEntryContainer.Builder)this.createItem(Items.CHORUS_FRUIT, 12).apply(this.countBetween(2, 6))).add((LootPoolEntryContainer.Builder)this.createItem(Items.BREAD, 8).apply(this.countBetween(2, 4))).add((LootPoolEntryContainer.Builder)this.createItem(Items.ENDER_PEARL, 8).apply(this.countBetween(1, 6))).add((LootPoolEntryContainer.Builder)this.createItem(EnderscapeItems.MURUBLIGHT_SHELF_ITEM.get(), 8).apply(this.countBetween(1, 2))).add((LootPoolEntryContainer.Builder)this.createItem(Items.GUNPOWDER, 6).apply(this.countBetween(4, 8))).add((LootPoolEntryContainer.Builder)this.createItem(Items.LEATHER, 6).apply(this.countBetween(4, 8))).add((LootPoolEntryContainer.Builder)this.createItem(Items.PAPER, 6).apply(this.countBetween(4, 8))).add((LootPoolEntryContainer.Builder)this.createItem(Items.SUGAR, 6).apply(this.countBetween(3, 6))).add((LootPoolEntryContainer.Builder)this.createItem(EnderscapeItems.FLANGER_BERRY.get(), 3).apply(this.countBetween(2, 8))).add((LootPoolEntryContainer.Builder)this.createItem(Items.BLACK_DYE, 3).apply(this.countBetween(1, 6))).add(this.createItem(EnderscapeItems.MUSIC_DISC_DECAY.get(), 3))));
        }
        catch (InterruptedException | ExecutionException exception) {
            throw new RuntimeException("Error processing loot table", exception);
        }
    }

    @NotNull
    private LootItemConditionalFunction.Builder<?> potionEffect(Holder<Potion> potion) throws InterruptedException, ExecutionException {
        return SetComponentsFunction.setComponent((DataComponentType)DataComponents.POTION_CONTENTS, (Object)new PotionContents(this.getPotion(potion)));
    }

    @NotNull
    private Holder.Reference<Potion> getPotion(Holder<Potion> potion) throws InterruptedException, ExecutionException {
        return this.lookup.lookupOrThrow(Registries.POTION).getOrThrow((ResourceKey)potion.unwrapKey().get());
    }

    @NotNull
    private LootItemConditionalFunction.Builder<?> countBetween(int f, int g) {
        return SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)f, (float)g));
    }

    @NotNull
    private LootPoolSingletonContainer.Builder<?> createItem(Item item, int weight) {
        return LootItem.lootTableItem((ItemLike)item).setWeight(weight);
    }

    @NotNull
    private LootPoolSingletonContainer.Builder<?> addBiomeExclusiveItem(Item item, ResourceKey<Biome> biome, int weight) throws InterruptedException, ExecutionException {
        return (LootPoolSingletonContainer.Builder)this.createItem(item, weight).when(LocationCheck.checkLocation((LocationPredicate.Builder)LocationPredicate.Builder.inBiome((Holder)this.lookup.lookupOrThrow(Registries.BIOME).getOrThrow(biome))));
    }

    @NotNull
    private LootPoolSingletonContainer.Builder<?> createEnchantedItem(Item item, int minEnchant, int maxEnchant, int weight) throws InterruptedException, ExecutionException {
        return this.createItem(item, weight).apply((LootItemFunction.Builder)EnchantWithLevelsFunction.enchantWithLevels((HolderLookup.Provider)this.lookup, (NumberProvider)UniformGenerator.between((float)minEnchant, (float)maxEnchant)));
    }

    @NotNull
    private LootPoolSingletonContainer.Builder<?> createEnchantedItem(Item item, ResourceKey<Enchantment> enchantment, UniformGenerator uniform, int weight) throws InterruptedException, ExecutionException {
        return this.createItem(item, weight).apply((LootItemFunction.Builder)new SetEnchantmentsFunction.Builder().withEnchantment((Holder)this.lookup.lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(enchantment), (NumberProvider)uniform));
    }
}

