/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.datagen;

import java.util.function.Function;
import net.bunten.enderscape.datagen.EnderscapeAdvancementProvider;
import net.bunten.enderscape.datagen.EnderscapeBannerPatternTagProvider;
import net.bunten.enderscape.datagen.EnderscapeBiomeModifiers;
import net.bunten.enderscape.datagen.EnderscapeBiomeTagProvider;
import net.bunten.enderscape.datagen.EnderscapeBlockTagProvider;
import net.bunten.enderscape.datagen.EnderscapeDamageTypeTagProvider;
import net.bunten.enderscape.datagen.EnderscapeDataMapProvider;
import net.bunten.enderscape.datagen.EnderscapeEnchantmentTagProvider;
import net.bunten.enderscape.datagen.EnderscapeEntityTagProvider;
import net.bunten.enderscape.datagen.EnderscapeItemTagProvider;
import net.bunten.enderscape.datagen.EnderscapeLootProvider;
import net.bunten.enderscape.datagen.EnderscapePaintingVariantTagProvider;
import net.bunten.enderscape.datagen.EnderscapePoiTagProvider;
import net.bunten.enderscape.datagen.EnderscapeRecipeProvider;
import net.bunten.enderscape.registry.EnderscapeBannerPatterns;
import net.bunten.enderscape.registry.EnderscapeBiomes;
import net.bunten.enderscape.registry.EnderscapeConfiguredFeatures;
import net.bunten.enderscape.registry.EnderscapeDamageTypes;
import net.bunten.enderscape.registry.EnderscapeEnchantments;
import net.bunten.enderscape.registry.EnderscapeJukeboxSongs;
import net.bunten.enderscape.registry.EnderscapeNoiseParameters;
import net.bunten.enderscape.registry.EnderscapePaintingVariants;
import net.bunten.enderscape.registry.EnderscapePlacedFeatures;
import net.bunten.enderscape.registry.EnderscapeRegistries;
import net.bunten.enderscape.registry.EnderscapeSkyParameters;
import net.bunten.enderscape.registry.EnderscapeTrimMaterials;
import net.bunten.enderscape.registry.EnderscapeTrimPatterns;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataProvider;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@EventBusSubscriber(modid="enderscape", bus=EventBusSubscriber.Bus.MOD)
public class EnderscapeDataGen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        RegistrySetBuilder registrySetBuilder = new RegistrySetBuilder();
        EnderscapeDataGen.buildRegistry(registrySetBuilder);
        event.createDatapackRegistryObjects(registrySetBuilder);
        EnderscapeDataGen.addProvider(event, EnderscapeAdvancementProvider::new);
        EnderscapeDataGen.addProvider(event, EnderscapeBannerPatternTagProvider::new);
        EnderscapeDataGen.addProvider(event, EnderscapeBiomeTagProvider::new);
        EnderscapeDataGen.addProvider(event, EnderscapeLootProvider::new);
        EnderscapeBlockTagProvider blockTagProvider = new EnderscapeBlockTagProvider(event);
        event.addProvider((DataProvider)blockTagProvider);
        EnderscapeDataGen.addProvider(event, EnderscapeDamageTypeTagProvider::new);
        EnderscapeDataGen.addProvider(event, EnderscapeEnchantmentTagProvider::new);
        EnderscapeDataGen.addProvider(event, EnderscapeEntityTagProvider::new);
        event.addProvider((DataProvider)new EnderscapeItemTagProvider(event, blockTagProvider));
        EnderscapeDataGen.addProvider(event, EnderscapePaintingVariantTagProvider::new);
        EnderscapeDataGen.addProvider(event, EnderscapePoiTagProvider::new);
        EnderscapeDataGen.addProvider(event, EnderscapeRecipeProvider::new);
        EnderscapeDataGen.addProvider(event, EnderscapeDataMapProvider::new);
    }

    private static void addProvider(GatherDataEvent event, Function<GatherDataEvent, DataProvider> provider) {
        event.addProvider(provider.apply(event));
    }

    private static void buildRegistry(RegistrySetBuilder builder) {
        builder.add(Registries.BANNER_PATTERN, new EnderscapeBannerPatterns()::bootstrap);
        builder.add(Registries.BIOME, new EnderscapeBiomes()::bootstrap);
        builder.add(Registries.CONFIGURED_FEATURE, new EnderscapeConfiguredFeatures()::bootstrap);
        builder.add(Registries.DAMAGE_TYPE, new EnderscapeDamageTypes()::bootstrap);
        builder.add(Registries.ENCHANTMENT, new EnderscapeEnchantments()::bootstrap);
        builder.add(Registries.JUKEBOX_SONG, new EnderscapeJukeboxSongs()::bootstrap);
        builder.add(Registries.NOISE, new EnderscapeNoiseParameters()::bootstrap);
        builder.add(Registries.PAINTING_VARIANT, new EnderscapePaintingVariants()::bootstrap);
        builder.add(Registries.PLACED_FEATURE, new EnderscapePlacedFeatures()::bootstrap);
        builder.add(Registries.TRIM_PATTERN, new EnderscapeTrimPatterns()::bootstrap);
        builder.add(Registries.TRIM_MATERIAL, new EnderscapeTrimMaterials()::bootstrap);
        builder.add(NeoForgeRegistries.Keys.BIOME_MODIFIERS, new EnderscapeBiomeModifiers()::bootstrap);
        builder.add(EnderscapeRegistries.SKY_PARAMETERS_KEY, new EnderscapeSkyParameters()::bootstrap);
    }
}

