/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.datagen;

import java.util.function.Supplier;
import net.bunten.enderscape.registry.EnderscapeBlocks;
import net.bunten.enderscape.registry.EnderscapeItems;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.data.DataMapProvider;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.registries.datamaps.builtin.Compostable;
import net.neoforged.neoforge.registries.datamaps.builtin.FurnaceFuel;
import net.neoforged.neoforge.registries.datamaps.builtin.NeoForgeDataMaps;

public class EnderscapeDataMapProvider
extends DataMapProvider {
    public EnderscapeDataMapProvider(GatherDataEvent event) {
        super(event.getGenerator().getPackOutput(), event.getLookupProvider());
    }

    protected void gather(HolderLookup.Provider provider) {
        DataMapProvider.Builder compost = this.builder(NeoForgeDataMaps.COMPOSTABLES);
        this.registerCompostableItem((DataMapProvider.Builder<Compostable, Item>)compost, 0.1f, EnderscapeBlocks.VEILED_LEAF_PILE);
        this.registerCompostableItem((DataMapProvider.Builder<Compostable, Item>)compost, 0.3f, EnderscapeBlocks.WISP_SPROUTS);
        this.registerCompostableItem((DataMapProvider.Builder<Compostable, Item>)compost, 0.3f, EnderscapeBlocks.CELESTIAL_CAP);
        this.registerCompostableItem((DataMapProvider.Builder<Compostable, Item>)compost, 0.3f, EnderscapeBlocks.CELESTIAL_GROWTH);
        this.registerCompostableItem((DataMapProvider.Builder<Compostable, Item>)compost, 0.3f, () -> Items.CHORUS_FRUIT);
        this.registerCompostableItem((DataMapProvider.Builder<Compostable, Item>)compost, 0.3f, EnderscapeBlocks.CORRUPT_GROWTH);
        this.registerCompostableItem((DataMapProvider.Builder<Compostable, Item>)compost, 0.3f, EnderscapeBlocks.MURUBLIGHT_CAP);
        this.registerCompostableItem((DataMapProvider.Builder<Compostable, Item>)compost, 0.3f, EnderscapeBlocks.VEILED_LEAVES);
        this.registerCompostableItem((DataMapProvider.Builder<Compostable, Item>)compost, 0.5f, EnderscapeItems.BLINKLIGHT);
        this.registerCompostableItem((DataMapProvider.Builder<Compostable, Item>)compost, 0.5f, EnderscapeBlocks.CHORUS_SPROUTS);
        this.registerCompostableItem((DataMapProvider.Builder<Compostable, Item>)compost, 0.5f, EnderscapeBlocks.DRY_END_GROWTH);
        this.registerCompostableItem((DataMapProvider.Builder<Compostable, Item>)compost, 0.5f, EnderscapeBlocks.WISP_GROWTH);
        this.registerCompostableItem((DataMapProvider.Builder<Compostable, Item>)compost, 0.5f, EnderscapeItems.FLANGER_BERRY);
        this.registerCompostableItem((DataMapProvider.Builder<Compostable, Item>)compost, 0.5f, EnderscapeBlocks.MURUBLIGHT_SHELF);
        this.registerCompostableItem((DataMapProvider.Builder<Compostable, Item>)compost, 0.5f, EnderscapeBlocks.VEILED_SAPLING);
        this.registerCompostableItem((DataMapProvider.Builder<Compostable, Item>)compost, 0.65f, EnderscapeBlocks.BULB_FLOWER);
        this.registerCompostableItem((DataMapProvider.Builder<Compostable, Item>)compost, 0.65f, EnderscapeBlocks.CELESTIAL_CHANTERELLE);
        this.registerCompostableItem((DataMapProvider.Builder<Compostable, Item>)compost, 0.65f, EnderscapeBlocks.MURUBLIGHT_CHANTERELLE);
        this.registerCompostableItem((DataMapProvider.Builder<Compostable, Item>)compost, 0.65f, EnderscapeBlocks.RIPE_FLANGER_BERRY_BLOCK);
        this.registerCompostableItem((DataMapProvider.Builder<Compostable, Item>)compost, 0.65f, EnderscapeBlocks.WISP_FLOWER);
        DataMapProvider.Builder fuel = this.builder(NeoForgeDataMaps.FURNACE_FUELS);
        fuel.add(BuiltInRegistries.ITEM.getKey((Object)EnderscapeBlocks.VOID_SHALE.get().asItem()), (Object)new FurnaceFuel(200), false, new ICondition[0]);
    }

    private void registerCompostableItem(DataMapProvider.Builder<Compostable, Item> builder, float v, Supplier<? extends ItemLike> wispFlower) {
        Item item = wispFlower.get().asItem();
        ResourceLocation key = BuiltInRegistries.ITEM.getKey((Object)item);
        builder.add(key, (Object)new Compostable(v, false), false, new ICondition[0]);
    }
}

